var ADIF_specification = {
	regexes:{
		'Digit':/^[0-9]$/,
		'Gridsquare':/^[A-R]{2}[0-9]{2}(?:[A-X]{2}(?:[0-9]{2})?)?$/,
		'Time':/^[0-9]{6}$/,
		'Date':/^[0-9]{9}$/,
		'Location':/^[NSEW][0-9]{3} [0-9]{2}\.[0-9]{3}$/,
		'Number':/^-?[0-9]*(?:\.[0-9]*)$/,
		'Boolean':/^[YN]$/,
		'String':/^[\x20-\xfe]*$/
	},
	validation_functions:{
		'Number':function(value) {
			if(value.search(/[0-9]/)==-1)
				return false;;
			if(value.parseInt(value, 10)==NaN)
				return false;
			return true;
		}
	},
	data_types:{
		'AwardList':{'indicator':'A', 'deprecated':true},
		'CreditList':{'indicator':'C'},
		'SponsoredAwardList':{'indicator':'P'},
		'Boolean':{'indicator':'B'},
		'Digit':{'indicator':'N'},
		'Number':{'indicator':'N'},
		'Character':{'indicator':'S'},
		'IntlCharacter':{'indicator':'I'},
		'Date':{'indicator':'D'},
		'Time':{'indicator':'T'},
		'String':{'indicator':'S'},
		'IntlString':{'indicator':'I'},
		'MultilineString':{'indicator':'M'},
		'IntlMultilineString':{'indicator':'G'},
		'Enumeration':{'indicator':'E'},
		'OmniscientEnumeration':{'indicator':'E'},
		'GridSquare':{},
		'GridSquareList':{},
		'Location':{'indicator':'L'},
		'SecondarySubdivisionList':{},
		'SOTARef':{},
	},
	enumerations:{
		'AntPath':{'values':[
			{'value':'G', 'meaning':'grayline'},
			{'value':'O', 'meaning':'other'},
			{'value':'S', 'meaning':'short path'},
			{'value':'L', 'meaning':'long path'}
		]},
		'ARRLSection':{'values':[
			{'value':'AL', 'meaning':'Alabama'},
			{'value':'AK', 'meaning':'Alaska'},
			{'value':'AB', 'meaning':'Alberta'},
			{'value':'AR', 'meaning':'Arkansas'},
			{'value':'AZ', 'meaning':'Arizona'},
			{'value':'BC', 'meaning':'British Columbia'},
			{'value':'CO', 'meaning':'Colorado'},
			{'value':'CT', 'meaning':'Connecticut'},
			{'value':'DE', 'meaning':'Delaware'},
			{'value':'EB', 'meaning':'East Bay'},
			{'value':'EMA', 'meaning':'Eastern Massachusetts'},
			{'value':'ENY', 'meaning':'Eastern New York'},
			{'value':'EPA', 'meaning':'Eastern Pennsylvania'},
			{'value':'EWA', 'meaning':'Eastern Washington'},
			{'value':'GA', 'meaning':'Georgia'},
			{'value':'ID', 'meaning':'Idaho'},
			{'value':'IL', 'meaning':'Illinois'},
			{'value':'IN', 'meaning':'Indiana'},
			{'value':'IA', 'meaning':'Iowa'},
			{'value':'KS', 'meaning':'Kansas'},
			{'value':'KY', 'meaning':'Kentucky'},
			{'value':'LAX', 'meaning':'Los Angeles'},
			{'value':'LA', 'meaning':'Louisiana'},
			{'value':'ME', 'meaning':'Maine'},
			{'value':'MB', 'meaning':'Manitoba'},
			{'value':'MAR', 'meaning':'Maritime'},
			{'value':'MDC', 'meaning':'Maryland-DC'},
			{'value':'MI', 'meaning':'Michigan'},
			{'value':'MN', 'meaning':'Minnesota'},
			{'value':'MS', 'meaning':'Mississippi'},
			{'value':'MO', 'meaning':'Missouri'},
			{'value':'MT', 'meaning':'Montana'},
			{'value':'NE', 'meaning':'Nebraska'},
			{'value':'NV', 'meaning':'Nevada'},
			{'value':'NH', 'meaning':'New Hampshire'},
			{'value':'NM', 'meaning':'New Mexico'},
			{'value':'NLI', 'meaning':'New York City-Long Island'},
			{'value':'NL', 'meaning':'Newfoundland/Labrador'},
			{'value':'NC', 'meaning':'North Carolina'},
			{'value':'ND', 'meaning':'North Dakota'},
			{'value':'NTX', 'meaning':'North Texas'},
			{'value':'NFL', 'meaning':'Northern Florida'},
			{'value':'NNJ', 'meaning':'Northern New Jersey'},
			{'value':'NNY', 'meaning':'Northern New York'},
			{'value':'NT', 'meaning':'Northwest Territories/Yukon/Nunavut'},
			{'value':'NWT', 'meaning':'Northwest Territories/Yukon/Nunavut (deprecated; use NT instead)'},
			{'value':'OH', 'meaning':'Ohio'},
			{'value':'OK', 'meaning':'Oklahoma'},
			{'value':'ON', 'meaning':'Ontario'},
			{'value':'ORG', 'meaning':'Orange'},
			{'value':'OR', 'meaning':'Oregon'},
			{'value':'PAC', 'meaning':'Pacific'},
			{'value':'PR', 'meaning':'Puerto Rico'},
			{'value':'QC', 'meaning':'Quebec'},
			{'value':'RI', 'meaning':'Rhode Island'},
			{'value':'SV', 'meaning':'Sacramento Valley'},
			{'value':'SDG', 'meaning':'San Diego'},
			{'value':'SF', 'meaning':'San Francisco'},
			{'value':'SJV', 'meaning':'San Joaquin Valley'},
			{'value':'SB', 'meaning':'Santa Barbara'},
			{'value':'SCV', 'meaning':'Santa Clara Valley'},
			{'value':'SK', 'meaning':'Saskatchewan'},
			{'value':'SC', 'meaning':'South Carolina'},
			{'value':'SD', 'meaning':'South Dakota'},
			{'value':'STX', 'meaning':'South Texas'},
			{'value':'SFL', 'meaning':'Southern Florida'},
			{'value':'SNJ', 'meaning':'Southern New Jersey'},
			{'value':'TN', 'meaning':'Tennessee'},
			{'value':'VI', 'meaning':'US Virgin Islands'},
			{'value':'UT', 'meaning':'Utah'},
			{'value':'VT', 'meaning':'Vermont'},
			{'value':'VA', 'meaning':'Virginia'},
			{'value':'WCF', 'meaning':'West Central Florida'},
			{'value':'WTX', 'meaning':'West Texas'},
			{'value':'WV', 'meaning':'West Virginia'},
			{'value':'WMA', 'meaning':'Western Massachusetts'},
			{'value':'WNY', 'meaning':'Western New York'},
			{'value':'WPA', 'meaning':'Western Pennsylvania'},
			{'value':'WWA', 'meaning':'Western Washington'},
			{'value':'WI', 'meaning':'Wisconsin'},
			{'value':'WY', 'meaning':'Wyoming'}
		]},
		'Band':{'values':[
			{'value':'2190m', 'meaning':'136KHz to 137KHz'},
			{'value':'630m', 'meaning':'472KHz to 479KHz'},
			{'value':'560m', 'meaning':'501KHz to 504KHz'},
			{'value':'160m', 'meaning':'1.8MHz to 2.0MHz'},
			{'value':'80m', 'meaning':'3.5MHz to 4.0MHz'},
			{'value':'60m', 'meaning':'5.102MHz to 5.4065MHz'},
			{'value':'40m', 'meaning':'7.0MHz to 7.3MHz'},
			{'value':'30m', 'meaning':'10.0MHz to 10.15MHz'},
			{'value':'20m', 'meaning':'14.0MHz to 14.35MHz'},
			{'value':'17m', 'meaning':'18.068MHz to 18.168MHz'},
			{'value':'15m', 'meaning':'21.0MHz to 21.45MHz'},
			{'value':'12m', 'meaning':'24.890MHz to 24.99MHz'},
			{'value':'10m', 'meaning':'28.0MHz to 29.7MHz'},
			{'value':'6m', 'meaning':'50MHz to 54MHz'},
			{'value':'4m', 'meaning':'70MHz to 71MHz'},
			{'value':'2m', 'meaning':'144MHz to 148MHz'},
			{'value':'1.25m', 'meaning':'222MHz to 225MHz'},
			{'value':'70cm', 'meaning':'420MHz to 450MHz'},
			{'value':'33cm', 'meaning':'902MHz to 928MHz'},
			{'value':'23cm', 'meaning':'1.24GHz to 1.3GHz'},
			{'value':'13cm', 'meaning':'2.3GHz to 2.45GHz'},
			{'value':'9cm', 'meaning':'3.3GHz to 3.5GHz'},
			{'value':'6cm', 'meaning':'5.65GHz to 5.925GHz'},
			{'value':'3cm', 'meaning':'10GHz to 10.5GHz'},
			{'value':'1.25cm', 'meaning':'24GHz to 24.25GHz'},
			{'value':'6mm', 'meaning':'47GHz to 47.2GHz'},
			{'value':'4mm', 'meaning':'75.5GHz to 81GHz'},
			{'value':'2.5mm', 'meaning':'119.98GHz to 120.02GHz'},
			{'value':'2mm', 'meaning':'142GHz to 149GHz'},
			{'value':'1mm', 'meaning':'241GHz to 250GHz'}
		]},
		'Continent':{'values':[
			{'value':'NA', 'meaning':'North America'},
			{'value':'SA', 'meaning':'South America'},
			{'value':'EU', 'meaning':'Europe'},
			{'value':'AF', 'meaning':'Africa'},
			{'value':'OC', 'meaning':'Oceana'},
			{'value':'AS', 'meaning':'Asia'},
			{'value':'AN', 'meaning':'Antarctica'}
		]},
		'CountryCode':{'values':[
			{'value':'1', 'meaning':'CANADA'},
			{'value':'2', 'meaning':'ABU AIL IS (deleted)', deleted:true},
			{'value':'3', 'meaning':'AFGHANISTAN'},
			{'value':'4', 'meaning':'AGALEGA & ST BRANDON'},
			{'value':'5', 'meaning':'ALAND IS'},
			{'value':'6', 'meaning':'ALASKA'},
			{'value':'7', 'meaning':'ALBANIA'},
			{'value':'8', 'meaning':'ALDABRA (deleted)', deleted:true},
			{'value':'9', 'meaning':'AMERICAN SAMOA'},
			{'value':'10', 'meaning':'AMSTERDAM & ST PAUL'},
			{'value':'11', 'meaning':'ANDAMAN & NICOBAR IS'},
			{'value':'12', 'meaning':'ANGUILLA'},
			{'value':'13', 'meaning':'ANTARCTICA'},
			{'value':'14', 'meaning':'ARMENIA'},
			{'value':'15', 'meaning':'ASIATIC RUSSIA'},
			{'value':'16', 'meaning':'AUCKLAND & CAMPBELL'},
			{'value':'17', 'meaning':'AVES ISLAND'},
			{'value':'18', 'meaning':'AZERBAIJAN'},
			{'value':'19', 'meaning':'BAJO NUEVO (deleted)', deleted:true},
			{'value':'20', 'meaning':'BAKER, HOWLAND IS'},
			{'value':'21', 'meaning':'BALEARIC IS'},
			{'value':'22', 'meaning':'PALAU'},
			{'value':'23', 'meaning':'BLENHEIM REEF (deleted)', deleted:true},
			{'value':'24', 'meaning':'BOUVET'},
			{'value':'25', 'meaning':'BRITISH N. BORNEO (deleted)', deleted:true},
			{'value':'26', 'meaning':'BRITISH SOMALI (deleted)', deleted:true},
			{'value':'27', 'meaning':'BELARUS'},
			{'value':'28', 'meaning':'CANAL ZONE (deleted)', deleted:true},
			{'value':'29', 'meaning':'CANARY IS'},
			{'value':'30', 'meaning':'CELEBE/MOLUCCA IS (deleted)', deleted:true},
			{'value':'31', 'meaning':'C KIRIBATI'},
			{'value':'32', 'meaning':'CEUTA & MELILLA'},
			{'value':'33', 'meaning':'CHAGOS'},
			{'value':'34', 'meaning':'CHATHAM IS'},
			{'value':'35', 'meaning':'CHRISTMAS IS'},
			{'value':'36', 'meaning':'CLIPPERTON IS'},
			{'value':'37', 'meaning':'COCOS ISLAND'},
			{'value':'38', 'meaning':'COCOS-KEELING IS'},
			{'value':'39', 'meaning':'COMOROS (deleted)', deleted:true},
			{'value':'40', 'meaning':'CRETE'},
			{'value':'41', 'meaning':'CROZET'},
			{'value':'42', 'meaning':'DAMAO, DUI (deleted)', deleted:true},
			{'value':'43', 'meaning':'DESECHEO IS'},
			{'value':'44', 'meaning':'DESROCHES (deleted)', deleted:true},
			{'value':'45', 'meaning':'DODECANESE'},
			{'value':'46', 'meaning':'EAST MALAYSIA'},
			{'value':'47', 'meaning':'EASTER IS'},
			{'value':'48', 'meaning':'EASTERN KIRIBATI'},
			{'value':'49', 'meaning':'EQUATORIAL GUINEA'},
			{'value':'50', 'meaning':'MEXICO'},
			{'value':'51', 'meaning':'ERITREA'},
			{'value':'52', 'meaning':'ESTONIA'},
			{'value':'53', 'meaning':'ETHIOPIA'},
			{'value':'54', 'meaning':'EUROPEAN RUSSIA'},
			{'value':'55', 'meaning':'FARQUHAR (deleted)', deleted:true},
			{'value':'56', 'meaning':'FERNANDO DE NORONHA'},
			{'value':'57', 'meaning':'FRENCH EQ. AFRICA (deleted)', deleted:true},
			{'value':'58', 'meaning':'FRENCH INDO-CHINA (deleted)', deleted:true},
			{'value':'59', 'meaning':'FRENCH WEST AFRICA (deleted)', deleted:true},
			{'value':'60', 'meaning':'BAHAMAS'},
			{'value':'61', 'meaning':'FRANZ JOSEF LAND'},
			{'value':'62', 'meaning':'BARBADOS'},
			{'value':'63', 'meaning':'FRENCH GUIANA'},
			{'value':'64', 'meaning':'BERMUDA'},
			{'value':'65', 'meaning':'BRITISH VIRGIN IS'},
			{'value':'66', 'meaning':'BELIZE'},
			{'value':'67', 'meaning':'FRENCH INDIA (deleted)', deleted:true},
			{'value':'68', 'meaning':'SAUDI/KUWAIT N.Z. (deleted)', deleted:true},
			{'value':'69', 'meaning':'CAYMAN ISLANDS'},
			{'value':'70', 'meaning':'CUBA'},
			{'value':'71', 'meaning':'GALAPAGOS'},
			{'value':'72', 'meaning':'DOMINICAN REPUBLIC'},
			{'value':'74', 'meaning':'EL SALVADOR'},
			{'value':'75', 'meaning':'GEORGIA'},
			{'value':'76', 'meaning':'GUATEMALA'},
			{'value':'77', 'meaning':'GRENADA'},
			{'value':'78', 'meaning':'HAITI'},
			{'value':'79', 'meaning':'GUADELOUPE'},
			{'value':'80', 'meaning':'HONDURAS'},
			{'value':'81', 'meaning':'GERMANY (deleted)', deleted:true},
			{'value':'82', 'meaning':'JAMAICA'},
			{'value':'84', 'meaning':'MARTINIQUE'},
			{'value':'85', 'meaning':'BONAIRE,CURACAO (deleted)', deleted:true},
			{'value':'86', 'meaning':'NICARAGUA'},
			{'value':'88', 'meaning':'PANAMA'},
			{'value':'89', 'meaning':'TURKS & CAICOS IS'},
			{'value':'90', 'meaning':'TRINIDAD & TOBAGO'},
			{'value':'91', 'meaning':'ARUBA'},
			{'value':'93', 'meaning':'GEYSER REEF (deleted)', deleted:true},
			{'value':'94', 'meaning':'ANTIGUA & BARBUDA'},
			{'value':'95', 'meaning':'DOMINICA'},
			{'value':'96', 'meaning':'MONTSERRAT'},
			{'value':'97', 'meaning':'ST LUCIA'},
			{'value':'98', 'meaning':'ST VINCENT'},
			{'value':'99', 'meaning':'GLORIOSO IS'},
			{'value':'100', 'meaning':'ARGENTINA'},
			{'value':'101', 'meaning':'GOA (deleted)', deleted:true},
			{'value':'102', 'meaning':'GOLD COAST, TOGOLAND (deleted)', deleted:true},
			{'value':'103', 'meaning':'GUAM'},
			{'value':'104', 'meaning':'BOLIVIA'},
			{'value':'105', 'meaning':'GUANTANAMO BAY'},
			{'value':'106', 'meaning':'GUERNSEY'},
			{'value':'107', 'meaning':'GUINEA'},
			{'value':'108', 'meaning':'BRAZIL'},
			{'value':'109', 'meaning':'GUINEA-BISSAU'},
			{'value':'110', 'meaning':'HAWAII'},
			{'value':'111', 'meaning':'HEARD IS'},
			{'value':'112', 'meaning':'CHILE'},
			{'value':'113', 'meaning':'IFNI (deleted)', deleted:true},
			{'value':'114', 'meaning':'ISLE OF MAN'},
			{'value':'115', 'meaning':'ITALIAN SOMALI (deleted)', deleted:true},
			{'value':'116', 'meaning':'COLOMBIA'},
			{'value':'117', 'meaning':'ITU HQ'},
			{'value':'118', 'meaning':'JAN MAYEN'},
			{'value':'119', 'meaning':'JAVA (deleted)', deleted:true},
			{'value':'120', 'meaning':'ECUADOR'},
			{'value':'122', 'meaning':'JERSEY'},
			{'value':'123', 'meaning':'JOHNSTON IS'},
			{'value':'124', 'meaning':'JUAN DE NOVA'},
			{'value':'125', 'meaning':'JUAN FERNANDEZ'},
			{'value':'126', 'meaning':'KALININGRAD'},
			{'value':'127', 'meaning':'KAMARAN IS (deleted)', deleted:true},
			{'value':'128', 'meaning':'KARELO-FINN REP (deleted)', deleted:true},
			{'value':'129', 'meaning':'GUYANA'},
			{'value':'130', 'meaning':'KAZAKHSTAN'},
			{'value':'131', 'meaning':'KERGUELEN'},
			{'value':'132', 'meaning':'PARAGUAY'},
			{'value':'133', 'meaning':'KERMADEC'},
			{'value':'134', 'meaning':'KINGMAN REEF'},
			{'value':'135', 'meaning':'KYRGYZSTAN'},
			{'value':'136', 'meaning':'PERU'},
			{'value':'137', 'meaning':'REPUBLIC OF KOREA'},
			{'value':'138', 'meaning':'KURE ISLAND'},
			{'value':'139', 'meaning':'KURIA MURIA IS (deleted)', deleted:true},
			{'value':'140', 'meaning':'SURINAME'},
			{'value':'141', 'meaning':'FALKLAND IS'},
			{'value':'142', 'meaning':'LAKSHADWEEP ISLANDS'},
			{'value':'143', 'meaning':'LAOS'},
			{'value':'144', 'meaning':'URUGUAY'},
			{'value':'145', 'meaning':'LATVIA'},
			{'value':'146', 'meaning':'LITHUANIA'},
			{'value':'147', 'meaning':'LORD HOWE IS'},
			{'value':'148', 'meaning':'VENEZUELA'},
			{'value':'149', 'meaning':'AZORES'},
			{'value':'150', 'meaning':'AUSTRALIA'},
			{'value':'151', 'meaning':'MALYJ VYSOTSKIIS (deleted)', deleted:true},
			{'value':'152', 'meaning':'MACAO'},
			{'value':'153', 'meaning':'MACQUARIE IS'},
			{'value':'154', 'meaning':'YEMEN ARAB REP (deleted)', deleted:true},
			{'value':'155', 'meaning':'MALAYA (deleted)', deleted:true},
			{'value':'157', 'meaning':'NAURU'},
			{'value':'158', 'meaning':'VANUATU'},
			{'value':'159', 'meaning':'MALDIVES'},
			{'value':'160', 'meaning':'TONGA'},
			{'value':'161', 'meaning':'MALPELO IS'},
			{'value':'162', 'meaning':'NEW CALEDONIA'},
			{'value':'163', 'meaning':'PAPUA NEW GUINEA'},
			{'value':'164', 'meaning':'MANCHURIA (deleted)', deleted:true},
			{'value':'165', 'meaning':'MAURITIUS IS'},
			{'value':'166', 'meaning':'MARIANA IS'},
			{'value':'167', 'meaning':'MARKET REEF'},
			{'value':'168', 'meaning':'MARSHALL IS'},
			{'value':'169', 'meaning':'MAYOTTE'},
			{'value':'170', 'meaning':'NEW ZEALAND'},
			{'value':'171', 'meaning':'MELLISH REEF'},
			{'value':'172', 'meaning':'PITCAIRN IS'},
			{'value':'173', 'meaning':'MICRONESIA'},
			{'value':'174', 'meaning':'MIDWAY IS'},
			{'value':'175', 'meaning':'FRENCH POLYNESIA'},
			{'value':'176', 'meaning':'FIJI'},
			{'value':'177', 'meaning':'MINAMI TORISHIMA'},
			{'value':'178', 'meaning':'MINERVA REEF (deleted)', deleted:true},
			{'value':'179', 'meaning':'MOLDOVA'},
			{'value':'180', 'meaning':'MOUNT ATHOS'},
			{'value':'181', 'meaning':'MOZAMBIQUE'},
			{'value':'182', 'meaning':'NAVASSA IS'},
			{'value':'183', 'meaning':'NETHERLANDS BORNEO (deleted)', deleted:true},
			{'value':'184', 'meaning':'NETHERLANDS N GUINEA (deleted)', deleted:true},
			{'value':'185', 'meaning':'SOLOMON ISLANDS'},
			{'value':'186', 'meaning':'NEWFOUNDLAND, LABRADOR (deleted)', deleted:true},
			{'value':'187', 'meaning':'NIGER'},
			{'value':'188', 'meaning':'NIUE'},
			{'value':'189', 'meaning':'NORFOLK IS'},
			{'value':'190', 'meaning':'SAMOA'},
			{'value':'191', 'meaning':'N COOK IS'},
			{'value':'192', 'meaning':'OGASAWARA'},
			{'value':'193', 'meaning':'OKINAWA (deleted)', deleted:true},
			{'value':'194', 'meaning':'OKINO TORI-SHIMA (deleted)', deleted:true},
			{'value':'195', 'meaning':'ANNOBON I.'},
			{'value':'196', 'meaning':'PALESTINE (deleted)', deleted:true},
			{'value':'197', 'meaning':'PALMYRA & JARVIS IS'},
			{'value':'198', 'meaning':'PAPUA TERR (deleted)', deleted:true},
			{'value':'199', 'meaning':'PETER I IS'},
			{'value':'200', 'meaning':'PORTUGUESE TIMOR (deleted)', deleted:true},
			{'value':'201', 'meaning':'PRINCE EDWARD & MARION'},
			{'value':'202', 'meaning':'PUERTO RICO'},
			{'value':'203', 'meaning':'ANDORRA'},
			{'value':'204', 'meaning':'REVILLAGIGEDO'},
			{'value':'205', 'meaning':'ASCENSION ISLAND'},
			{'value':'206', 'meaning':'AUSTRIA'},
			{'value':'207', 'meaning':'RODRIGUEZ IS'},
			{'value':'208', 'meaning':'RUANDA-URUNDI (deleted)', deleted:true},
			{'value':'209', 'meaning':'BELGIUM'},
			{'value':'210', 'meaning':'SAAR (deleted)', deleted:true},
			{'value':'211', 'meaning':'SABLE ISLAND'},
			{'value':'212', 'meaning':'BULGARIA'},
			{'value':'213', 'meaning':'SAINT MARTIN'},
			{'value':'214', 'meaning':'CORSICA'},
			{'value':'215', 'meaning':'CYPRUS'},
			{'value':'216', 'meaning':'SAN ANDRES & PROVIDENCIA'},
			{'value':'217', 'meaning':'SAN FELIX'},
			{'value':'218', 'meaning':'CZECHOSLOVAKIA (deleted)', deleted:true},
			{'value':'219', 'meaning':'SAO TOME & PRINCIPE'},
			{'value':'220', 'meaning':'SARAWAK (deleted)', deleted:true},
			{'value':'221', 'meaning':'DENMARK'},
			{'value':'222', 'meaning':'FAROE IS'},
			{'value':'223', 'meaning':'ENGLAND'},
			{'value':'224', 'meaning':'FINLAND'},
			{'value':'225', 'meaning':'SARDINIA'},
			{'value':'226', 'meaning':'SAUDI/IRAQ N.Z. (deleted)', deleted:true},
			{'value':'227', 'meaning':'FRANCE'},
			{'value':'228', 'meaning':'SERRANA BANK & RONCADOR CAY (deleted)', deleted:true},
			{'value':'229', 'meaning':'GERMAN DEM. REP. (deleted)', deleted:true},
			{'value':'230', 'meaning':'FED REP OF GERMANY'},
			{'value':'231', 'meaning':'SIKKIM (deleted)', deleted:true},
			{'value':'232', 'meaning':'SOMALIA'},
			{'value':'233', 'meaning':'GIBRALTAR'},
			{'value':'234', 'meaning':'S COOK IS'},
			{'value':'235', 'meaning':'SOUTH GEORGIA IS'},
			{'value':'236', 'meaning':'GREECE'},
			{'value':'237', 'meaning':'GREENLAND'},
			{'value':'238', 'meaning':'SOUTH ORKNEY IS'},
			{'value':'239', 'meaning':'HUNGARY'},
			{'value':'240', 'meaning':'SOUTH SANDWICH ISLANDS'},
			{'value':'241', 'meaning':'SOUTH SHETLAND ISLANDS'},
			{'value':'242', 'meaning':'ICELAND'},
			{'value':'243', 'meaning':'DEM REP OF YEMEN (deleted)', deleted:true},
			{'value':'244', 'meaning':'SOUTHERN SUDAN (deleted)', deleted:true},
			{'value':'245', 'meaning':'IRELAND'},
			{'value':'246', 'meaning':'SOV MILITARY ORDER OF MALTA'},
			{'value':'247', 'meaning':'SPRATLY IS'},
			{'value':'248', 'meaning':'ITALY'},
			{'value':'249', 'meaning':'ST KITTS & NEVIS'},
			{'value':'250', 'meaning':'ST HELENA IS'},
			{'value':'251', 'meaning':'LIECHTENSTEIN'},
			{'value':'252', 'meaning':'ST PAUL ISLAND'},
			{'value':'253', 'meaning':'ST. PETER & ST. PAUL ROCKS'},
			{'value':'254', 'meaning':'LUXEMBOURG'},
			{'value':'255', 'meaning':'SINT MAARTEN, SABA, ST EUSTATIUS (deleted)', deleted:true},
			{'value':'256', 'meaning':'MADEIRA IS'},
			{'value':'257', 'meaning':'MALTA'},
			{'value':'258', 'meaning':'SUMATRA (deleted)', deleted:true},
			{'value':'259', 'meaning':'SVALBARD IS'},
			{'value':'260', 'meaning':'MONACO'},
			{'value':'261', 'meaning':'SWAN ISLAND (deleted)', deleted:true},
			{'value':'262', 'meaning':'TAJIKISTAN'},
			{'value':'263', 'meaning':'NETHERLANDS'},
			{'value':'264', 'meaning':'TANGIER (deleted)', deleted:true},
			{'value':'265', 'meaning':'NORTHERN IRELAND'},
			{'value':'266', 'meaning':'NORWAY'},
			{'value':'267', 'meaning':'TERR NEW GUINEA (deleted)', deleted:true},
			{'value':'268', 'meaning':'TIBET (deleted)', deleted:true},
			{'value':'269', 'meaning':'POLAND'},
			{'value':'270', 'meaning':'TOKELAU IS'},
			{'value':'271', 'meaning':'TRIESTE (deleted)', deleted:true},
			{'value':'272', 'meaning':'PORTUGAL'},
			{'value':'273', 'meaning':'TRINDADE & MARTIN VAZ ISLANDS'},
			{'value':'274', 'meaning':'TRISTAN DA CUNHA & GOUGH IS'},
			{'value':'275', 'meaning':'ROMANIA'},
			{'value':'276', 'meaning':'TROMELIN'},
			{'value':'277', 'meaning':'ST PIERRE & MIQUELON'},
			{'value':'278', 'meaning':'SAN MARINO'},
			{'value':'279', 'meaning':'SCOTLAND'},
			{'value':'280', 'meaning':'TURKMENISTAN'},
			{'value':'281', 'meaning':'SPAIN'},
			{'value':'282', 'meaning':'TUVALU'},
			{'value':'283', 'meaning':'UK BASES ON CYPRUS'},
			{'value':'284', 'meaning':'SWEDEN'},
			{'value':'285', 'meaning':'US VIRGIN ISLANDS'},
			{'value':'286', 'meaning':'UGANDA'},
			{'value':'287', 'meaning':'SWITZERLAND'},
			{'value':'288', 'meaning':'UKRAINE'},
			{'value':'289', 'meaning':'UNITED NATIONS HQ'},
			{'value':'291', 'meaning':'UNITED STATES'},
			{'value':'292', 'meaning':'UZBEKISTAN'},
			{'value':'293', 'meaning':'VIETNAM'},
			{'value':'294', 'meaning':'WALES'},
			{'value':'295', 'meaning':'VATICAN'},
			{'value':'296', 'meaning':'SERBIA'},
			{'value':'297', 'meaning':'WAKE IS'},
			{'value':'298', 'meaning':'WALLIS & FUTUNA'},
			{'value':'299', 'meaning':'WEST MALAYSIA'},
			{'value':'301', 'meaning':'W KIRIBATI'},
			{'value':'302', 'meaning':'WESTERN SAHARA'},
			{'value':'303', 'meaning':'WILLIS IS'},
			{'value':'304', 'meaning':'BAHRAIN'},
			{'value':'305', 'meaning':'BANGLADESH'},
			{'value':'306', 'meaning':'BHUTAN'},
			{'value':'307', 'meaning':'ZANZIBAR (deleted)', deleted:true},
			{'value':'308', 'meaning':'COSTA RICA'},
			{'value':'309', 'meaning':'MYANMAR'},
			{'value':'312', 'meaning':'CAMBODIA'},
			{'value':'315', 'meaning':'SRI LANKA'},
			{'value':'318', 'meaning':'CHINA'},
			{'value':'321', 'meaning':'HONG KONG'},
			{'value':'324', 'meaning':'INDIA'},
			{'value':'327', 'meaning':'INDONESIA'},
			{'value':'330', 'meaning':'IRAN'},
			{'value':'333', 'meaning':'IRAQ'},
			{'value':'336', 'meaning':'ISRAEL'},
			{'value':'339', 'meaning':'JAPAN'},
			{'value':'342', 'meaning':'JORDAN'},
			{'value':'344', 'meaning':"DEMOCRATIC PEOPLE'S REPUBLIC OF KOREA"},
			{'value':'345', 'meaning':'BRUNEI'},
			{'value':'348', 'meaning':'KUWAIT'},
			{'value':'354', 'meaning':'LEBANON'},
			{'value':'363', 'meaning':'MONGOLIA'},
			{'value':'369', 'meaning':'NEPAL'},
			{'value':'370', 'meaning':'OMAN'},
			{'value':'372', 'meaning':'PAKISTAN'},
			{'value':'375', 'meaning':'PHILIPPINES'},
			{'value':'376', 'meaning':'QATAR'},
			{'value':'378', 'meaning':'SAUDI ARABIA'},
			{'value':'379', 'meaning':'SEYCHELLES'},
			{'value':'381', 'meaning':'SINGAPORE'},
			{'value':'382', 'meaning':'DJIBOUTI'},
			{'value':'384', 'meaning':'SYRIA'},
			{'value':'386', 'meaning':'TAIWAN'},
			{'value':'387', 'meaning':'THAILAND'},
			{'value':'390', 'meaning':'TURKEY'},
			{'value':'391', 'meaning':'UNITED ARAB EMIRATES'},
			{'value':'400', 'meaning':'ALGERIA'},
			{'value':'401', 'meaning':'ANGOLA'},
			{'value':'402', 'meaning':'BOTSWANA'},
			{'value':'404', 'meaning':'BURUNDI'},
			{'value':'406', 'meaning':'CAMEROON'},
			{'value':'408', 'meaning':'CENTRAL AFRICAN REPUBLIC'},
			{'value':'409', 'meaning':'CAPE VERDE'},
			{'value':'410', 'meaning':'CHAD'},
			{'value':'411', 'meaning':'COMOROS'},
			{'value':'412', 'meaning':'REPUBLIC OF THE CONGO'},
			{'value':'414', 'meaning':'DEM. REPUBLIC OF THE CONGO'},
			{'value':'416', 'meaning':'BENIN'},
			{'value':'420', 'meaning':'GABON'},
			{'value':'422', 'meaning':'THE GAMBIA'},
			{'value':'424', 'meaning':'GHANA'},
			{'value':'428', 'meaning':"COTE D'IVOIRE"},
			{'value':'430', 'meaning':'KENYA'},
			{'value':'432', 'meaning':'LESOTHO'},
			{'value':'434', 'meaning':'LIBERIA'},
			{'value':'436', 'meaning':'LIBYA'},
			{'value':'438', 'meaning':'MADAGASCAR'},
			{'value':'440', 'meaning':'MALAWI'},
			{'value':'442', 'meaning':'MALI'},
			{'value':'444', 'meaning':'MAURITANIA'},
			{'value':'446', 'meaning':'MOROCCO'},
			{'value':'450', 'meaning':'NIGERIA'},
			{'value':'452', 'meaning':'ZIMBABWE'},
			{'value':'453', 'meaning':'REUNION'},
			{'value':'454', 'meaning':'RWANDA'},
			{'value':'456', 'meaning':'SENEGAL'},
			{'value':'458', 'meaning':'SIERRA LEONE'},
			{'value':'460', 'meaning':'ROTUMA IS'},
			{'value':'462', 'meaning':'REPUBLIC OF SOUTH AFRICA'},
			{'value':'464', 'meaning':'NAMIBIA'},
			{'value':'466', 'meaning':'SUDAN'},
			{'value':'468', 'meaning':'SWAZILAND'},
			{'value':'470', 'meaning':'TANZANIA'},
			{'value':'474', 'meaning':'TUNISIA'},
			{'value':'478', 'meaning':'EGYPT'},
			{'value':'480', 'meaning':'BURKINA-FASO'},
			{'value':'482', 'meaning':'ZAMBIA'},
			{'value':'483', 'meaning':'TOGO'},
			{'value':'488', 'meaning':'WALVIS BAY (deleted)', deleted:true},
			{'value':'489', 'meaning':'CONWAY REEF'},
			{'value':'490', 'meaning':'BANABA ISLAND'},
			{'value':'492', 'meaning':'YEMEN'},
			{'value':'493', 'meaning':'PENGUIN ISLANDS (deleted)', deleted:true},
			{'value':'497', 'meaning':'CROATIA'},
			{'value':'499', 'meaning':'SLOVENIA'},
			{'value':'501', 'meaning':'BOSNIA-HERZEGOVINA'},
			{'value':'502', 'meaning':'MACEDONIA'},
			{'value':'503', 'meaning':'CZECH REPUBLIC'},
			{'value':'504', 'meaning':'SLOVAK REPUBLIC'},
			{'value':'505', 'meaning':'PRATAS IS'},
			{'value':'506', 'meaning':'SCARBOROUGH REEF'},
			{'value':'507', 'meaning':'TEMOTU PROVINCE'},
			{'value':'508', 'meaning':'AUSTRAL IS'},
			{'value':'509', 'meaning':'MARQUESAS IS'},
			{'value':'510', 'meaning':'PALESTINE'},
			{'value':'511', 'meaning':'TIMOR-LESTE'},
			{'value':'512', 'meaning':'CHESTERFIELD IS'},
			{'value':'513', 'meaning':'DUCIE IS'},
			{'value':'514', 'meaning':'MONTENEGRO'},
			{'value':'515', 'meaning':'SWAINS ISLAND'},
			{'value':'516', 'meaning':'ST. BARTHELEMY'},
			{'value':'517', 'meaning':'CURACAO'},
			{'value':'518', 'meaning':'SINT MAARTEN'},
			{'value':'519', 'meaning':'ST EUSTATIUS AND SABA'},
			{'value':'520', 'meaning':'BONAIRE'},
			{'value':'521', 'meaning':'SOUTH SUDAN'}
		]},
		'Mode':{'values':[
			{'value':'AM'},
			{'value':'ATV'},
			{'value':'CHIP', 'submodes':['CHIP64', 'CHIP128']},
			{'value':'CLO'},
			{'value':'CONTESTI'},
			{'value':'CW', 'submodes':['PCW']},
			{'value':'DIGITALVOICE'},
			{'value':'DOMINO', 'submodes':['DOMINOEX', 'DOMINOF']},
			{'value':'DSTAR'},
			{'value':'FAX'},
			{'value':'FM'},
			{'value':'FSK441'},
			{'value':'HELL', 'submodes':['FMHELL', 'FSKHELL', 'HELL80', 'HFSK', 'PSKHELL']},
			{'value':'ISCAT', 'submodes':['ISCAT-A', 'ISCAT-B']},
			{'value':'JT4', 'submodes':['JT4A', 'JT4B', 'JT4C', 'JT4D', 'JT4E', 'JT4F', 'JT4G']},
			{'value':'JT6M'},
			{'value':'JT9', 'submodes':['JT9-1', 'JT9-2', 'JT9-5', 'JT9-10', 'JT9-30']},
			{'value':'JT44'},
			{'value':'JT65', 'submodes':['JT65A', 'JT65B', 'JT65B2', 'JT65C', 'JT65C2']},
			{'value':'MFSK', 'submodes':['MFSK4', 'MFSK8', 'MFSK11', 'MFSK16', 'MFSK22', 'MFSK31', 'MFSK32', 'MFSK64', 'MFSK128']},
			{'value':'MT63'},
			{'value':'OLIVIA', 'submodes':['OLIVIA 4/125', 'OLIVIA 4/250', 'OLIVIA 8/250', 'OLIVIA 8/500', 'OLIVIA 16/500', 'OLIVIA 16/1000', 'OLIVIA 32/1000']},
			{'value':'OPERA', 'submodes':['OPERA-BEACON', 'OPERA-QSO']},
			{'value':'PAC', 'submodes':['PAC2', 'PAC3', 'PAC4']},
			{'value':'PAX', 'submodes':['PAX2']},
			{'value':'PKT'},
			{'value':'PSK', 'submodes':['FSK31', 'PSK10', 'PSK31', 'PSK63', 'PSK63F', 'PSK125', 'PSK250', 'PSK500', 'PSK1000', 'PSKAM10', 'PSKAM31', 'PSKAM50', 'PSKFEC31', 'QPSK31', 'QPSK63', 'QPSK125', 'QPSK250', 'QPSK500']},
			{'value':'PSK2K'},
			{'value':'Q15'},
			{'value':'ROS', 'submodes':['ROS-EME', 'ROS-HF', 'ROS-MF']},
			{'value':'RTTY', 'submodes':['ASCI']},
			{'value':'RTTYM'},
			{'value':'SSB', 'submodes':['LSB', 'USB']},
			{'value':'SSTV'},
			{'value':'THOR'},
			{'value':'THRB', 'submodes':['THRBX']},
			{'value':'TOR', 'submodes':['AMTORFEC', 'GTOR']},
			{'value':'V4'},
			{'value':'VOI'},
			{'value':'WINMOR'},
			{'value':'WSPR'}
		]},
		'Submode':{'values':[
			{'value':'AMTORFEC', 'mode':'TOR'},
			{'value':'ASCI', 'mode':'RTTY'},
			{'value':'CHIP64', 'mode':'CHIP'},
			{'value':'CHIP128', 'mode':'CHIP'},
			{'value':'DOMINOEX', 'mode':'DOMINO'},
			{'value':'DOMINOF', 'mode':'DOMINO'},
			{'value':'FMHELL', 'mode':'HELL'},
			{'value':'FSK31', 'mode':'PSK'},
			{'value':'FSKHELL', 'mode':'HELL'},
			{'value':'GTOR', 'mode':'TOR'},
			{'value':'HELL80', 'mode':'HELL'},
			{'value':'HFSK', 'mode':'HELL'},
			{'value':'ISCAT-A', 'mode':'ISCAT'},
			{'value':'ISCAT-B', 'mode':'ISCAT'},
			{'value':'JT4A', 'mode':'JT4'},
			{'value':'JT4B', 'mode':'JT4'},
			{'value':'JT4C', 'mode':'JT4'},
			{'value':'JT4D', 'mode':'JT4'},
			{'value':'JT4E', 'mode':'JT4'},
			{'value':'JT4F', 'mode':'JT4'},
			{'value':'JT4G', 'mode':'JT4'},
			{'value':'JT9-1', 'mode':'JT9'},
			{'value':'JT9-2', 'mode':'JT9'},
			{'value':'JT9-5', 'mode':'JT9'},
			{'value':'JT9-10', 'mode':'JT9'},
			{'value':'JT9-30', 'mode':'JT9'},
			{'value':'JT65A', 'mode':'JT65'},
			{'value':'JT65B', 'mode':'JT65'},
			{'value':'JT65B2', 'mode':'JT65'},
			{'value':'JT65C', 'mode':'JT65'},
			{'value':'JT65C2', 'mode':'JT65'},
			{'value':'LSB', 'mode':'SSB', 'desc':'Amplitude modulated voice telephony, lower-sideband, suppressed-carrier'},
			{'value':'MFSK4', 'mode':'MFSK'},
			{'value':'MFSK8', 'mode':'MFSK'},
			{'value':'MFSK11', 'mode':'MFSK'},
			{'value':'MFSK16', 'mode':'MFSK'},
			{'value':'MFSK22', 'mode':'MFSK'},
			{'value':'MFSK31', 'mode':'MFSK'},
			{'value':'MFSK32', 'mode':'MFSK'},
			{'value':'MFSK64', 'mode':'MFSK'},
			{'value':'MFSK128', 'mode':'MFSK'},
			{'value':'OLIVIA 4/125', 'mode':'OLIVIA'},
			{'value':'OLIVIA 4/250', 'mode':'OLIVIA'},
			{'value':'OLIVIA 8/250', 'mode':'OLIVIA'},
			{'value':'OLIVIA 8/500', 'mode':'OLIVIA'},
			{'value':'OLIVIA 16/500', 'mode':'OLIVIA'},
			{'value':'OLIVIA 16/1000', 'mode':'OLIVIA'},
			{'value':'OLIVIA 32/1000', 'mode':'OLIVIA'},
			{'value':'OPERA-BEACON', 'mode':'OPERA'},
			{'value':'OPERA-QSO', 'mode':'OPERA'},
			{'value':'PAC2', 'mode':'PAC'},
			{'value':'PAC3', 'mode':'PAC'},
			{'value':'PAC4', 'mode':'PAC'},
			{'value':'PAX2', 'mode':'PAX'},
			{'value':'PCW', 'mode':'CW'},
			{'value':'PSK10', 'mode':'PSK'},
			{'value':'PSK31', 'mode':'PSK'},
			{'value':'PSK63', 'mode':'PSK'},
			{'value':'PSK63F', 'mode':'PSK'},
			{'value':'PSK125', 'mode':'PSK'},
			{'value':'PSK250', 'mode':'PSK'},
			{'value':'PSK500', 'mode':'PSK'},
			{'value':'PSK1000', 'mode':'PSK'},
			{'value':'PSKAM10', 'mode':'PSK'},
			{'value':'PSKAM31', 'mode':'PSK'},
			{'value':'PSKAM50', 'mode':'PSK'},
			{'value':'PSKFEC31', 'mode':'PSK'},
			{'value':'PSKHELL', 'mode':'HELL'},
			{'value':'QPSK31', 'mode':'PSK'},
			{'value':'QPSK63', 'mode':'PSK'},
			{'value':'QPSK125', 'mode':'PSK'},
			{'value':'QPSK250', 'mode':'PSK'},
			{'value':'QPSK500', 'mode':'PSK'},
			{'value':'ROS-EME', 'mode':'ROS'},
			{'value':'ROS-HF', 'mode':'ROS'},
			{'value':'ROS-MF', 'mode':'ROS'},
			{'value':'THRBX', 'mode':'THRB'},
			{'value':'USB', 'mode':'SSB', 'desc':'Amplitude modulated voice telephony, upper-sideband, suppressed-carrier'}
		]},
		'QSOUploadStatus':{'values':[
			{'value':'Y', 'meaning':'the QSO has been uploaded to, and accepted by, the online service'},
			{'value':'N', 'meaning':'do not upload the QSO to the online service'},
			{'value':'M', 'meaning':'the QSO has been modified since being uploaded to the online service'}
		]},
		'ContestID':{'values':[
			{'value':'070-PSKFEST', 'meaning':'PODXS PSKFest'},
			{'value':'070-VALENTINE-SPRINT', 'meaning':'PODXS Valentine Sprint'},
			{'value':'070-ST-PATS-DAY', 'meaning':'PODXS St. Patricks Day'},
			{'value':'070-31-FLAVORS', 'meaning':'PODXS 31 Flavors'},
			{'value':'070-3-DAY', 'meaning':'PODXS Three Day Weekend'},
			{'value':'070-40M-SPRINT', 'meaning':'PODXS 40m Firecracker Sprint'},
			{'value':'070-80M-SPRINT', 'meaning':'PODXS 80m Jay Hudak Memorial Sprint'},
			{'value':'070-160M-SPRINT', 'meaning':'PODXS Great Pumpkin Sprint'},
			{'value':'10-RTTY', 'meaning':'Ten-Meter RTTY Contest (2011 onwards)'},
			{'value':'1010-OPEN-SEASON', 'meaning':'Open Season Ten Meter QSO Party'},
			{'value':'7QP', 'meaning':'7th-Area QSO Party'},
			{'value':'AL-QSO-PARTY', 'meaning':'Alabama QSO Party'},
			{'value':'ALL-ASIAN-DX-CW', 'meaning':'JARL All Asian DX Contest (CW)'},
			{'value':'ALL-ASIAN-DX-PHONE', 'meaning':'JARL All Asian DX Contest (PHONE)'},
			{'value':'ANARTS-RTTY', 'meaning':'ANARTS WW RTTY'},
			{'value':'ANATOLIAN-RTTY', 'meaning':'Anatolian WW RTTY'},
			{'value':'AP-SPRINT', 'meaning':'Asia - Pacific Sprint'},
			{'value':'AR-QSO-PARTY', 'meaning':'Arkansas QSO Party'},
			{'value':'ARI-DX', 'meaning':'ARI DX Contest'},
			{'value':'ARRL-10', 'meaning':'ARRL 10 Meter Contest'},
			{'value':'ARRL-160', 'meaning':'ARRL 160 Meter Contest'},
			{'value':'ARRL-DX-CW', 'meaning':'ARRL International DX Contest (CW)'},
			{'value':'ARRL-DX-SSB', 'meaning':'ARRL International DX Contest (Phone)'},
			{'value':'ARRL-FIELD-DAY', 'meaning':'ARRL Field Day'},
			{'value':'ARRL-RR-CW', 'meaning':'ARRL Rookie Roundup (CW)'},
			{'value':'ARRL-RR-RTTY', 'meaning':'ARRL Rookie Roundup (RTTY)'},
			{'value':'ARRL-RR-SSB', 'meaning':'ARRL Rookie Roundup (Phone)'},
			{'value':'ARRL-RTTY', 'meaning':'ARRL RTTY Round-Up'},
			{'value':'ARRL-SCR', 'meaning':'ARRL School Club Roundup'},
			{'value':'ARRL-SS-CW', 'meaning':'ARRL November Sweepstakes (CW)'},
			{'value':'ARRL-SS-SSB', 'meaning':'ARRL November Sweepstakes (Phone)'},
			{'value':'ARRL-UHF-AUG', 'meaning':'ARRL August UHF Contest'},
			{'value':'ARRL-VHF-JAN', 'meaning':'ARRL January VHF Sweepstakes'},
			{'value':'ARRL-VHF-JUN', 'meaning':'ARRL June VHF QSO Party'},
			{'value':'ARRL-VHF-SEP', 'meaning':'ARRL September VHF QSO Party'},
			{'value':'AZ-QSO-PARTY', 'meaning':'Arizona QSO Party'},
			{'value':'BARTG-RTTY', 'meaning':'BARTG Spring RTTY Contest'},
			{'value':'BARTG-SPRINT', 'meaning':'BARTG Sprint Contest'},
			{'value':'BC-QSO-PARTY', 'meaning':'British Columbia QSO Party'},
			{'value':'CA-QSO-PARTY', 'meaning':'California QSO Party'},
			{'value':'CO-QSO-PARTY', 'meaning':'Colorado QSO Party'},
			{'value':'CQ-160-CW', 'meaning':'CQ WW 160 Meter DX Contest (CW)'},
			{'value':'CQ-160-SSB', 'meaning':'CQ WW 160 Meter DX Contest (SSB)'},
			{'value':'CQ-M', 'meaning':'CQ-M International DX Contest'},
			{'value':'CQ-VHF', 'meaning':'CQ World-Wide VHF Contest'},
			{'value':'CQ-WPX-CW', 'meaning':'CQ WW WPX Contest (CW)'},
			{'value':'CQ-WPX-RTTY', 'meaning':'CQ/RJ WW RTTY WPX Contest'},
			{'value':'CQ-WPX-SSB', 'meaning':'CQ WW WPX Contest (SSB)'},
			{'value':'CQ-WW-CW', 'meaning':'CQ WW DX Contest (CW)'},
			{'value':'CQ-WW-RTTY', 'meaning':'CQ/RJ WW RTTY DX Contest'},
			{'value':'CQ-WW-SSB', 'meaning':'CQ WW DX Contest (SSB)'},
			{'value':'CWOPS-CWT', 'meaning':'CWops Mini-CWT Test'},
			{'value':'CIS-DX', 'meaning':'CIS DX Contest'},
			{'value':'CT-QSO-PARTY', 'meaning':'Connecticut QSO Party'},
			{'value':'CVA-DX-CW', 'meaning':'Concurso Verde e Amarelo DX CW Contest'},
			{'value':'CVA-DX-SSB', 'meaning':'Concurso Verde e Amarelo DX CW Contest'},
			{'value':'DARC-WAEDC-CW', 'meaning':'WAE DX Contest (CW)'},
			{'value':'DARC-WAEDC-RTTY', 'meaning':'WAE DX Contest (RTTY)'},
			{'value':'DARC-WAEDC-SSB', 'meaning':'WAE DX Contest (SSB)'},
			{'value':'DARC-WAG', 'meaning':'DARC Worked All Germany'},
			{'value':'DE-QSO-PARTY', 'meaning':'Delaware QSO Party'},
			{'value':'DL-DX-RTTY', 'meaning':'DL-DX RTTY Contest'},
			{'value':'DMC-RTTY', 'meaning':'DMC RTTY Contest'},
			{'value':'EA-CNCW', 'meaning':'Concurso Nacional de Telegraf\xc3\xada'},
			{'value':'EA-DME', 'meaning':'Municipios Espa\xc3\xb1oles'},
			{'value':'EA-PSK63', 'meaning':'EA PSK63'},
			{'value':'EA-RTTY', 'meaning':'Uni\xc3\xb3n de Radioaficionados Espa\xc3\xb1oles RTTY Contest'},
			{'value':'EA-SMRE-CW', 'meaning':'Su Majestad El Rey de Espa\xc3\xb1a - CW'},
			{'value':'EA-SMRE-SSB', 'meaning':'Su Majestad El Rey de Espa\xc3\xb1a - SSB'},
			{'value':'EA-VHF-ATLANTIC', 'meaning':'Atl\xc3\xa1ntico V-UHF'},
			{'value':'EA-VHF-COM', 'meaning':'Combinado de V-UHF'},
			{'value':'EA-VHF-COSTA-SOL', 'meaning':'Costa del Sol V-UHF'},
			{'value':'EA-VHF-EA', 'meaning':'Nacional VHF'},
			{'value':'EA-VHF-EA1RCS', 'meaning':'Segovia EA1RCS V-UHF'},
			{'value':'EA-VHF-QSL', 'meaning':'QSL V-UHF & 50MHz'},
			{'value':'EA-VHF-SADURNI', 'meaning':'Sant Sadurni V-UHF'},
			{'value':'EA-WW-RTTY', 'meaning':'Uni\xc3\xb3n de Radioaficionados Espa\xc3\xb1oles RTTY Contest'},
			{'value':'EPC-PSK63', 'meaning':'PSK63 QSO Party'},
			{'value':'EU', 'meaning':'Sprint  EU Sprint'},
			{'value':'EUCW160M', 'meaning':'European CW Association 160m CW Party'},
			{'value':'EU-HF', 'meaning':'EU HF Championship'},
			{'value':'EU-PSK-DX', 'meaning':'EU PSK DX Contest'},
			{'value':'Fall', 'meaning':'Sprint        FISTS Fall Sprint'},
			{'value':'FL-QSO-PARTY', 'meaning':'Florida QSO Party'},
			{'value':'GA-QSO-PARTY', 'meaning':'Georgia QSO Party'},
			{'value':'HELVETIA', 'meaning':'Helvetia Contest'},
			{'value':'HI-QSO-PARTY', 'meaning':'Hawaiian QSO Party'},
			{'value':'HOLYLAND', 'meaning':'IARC Holyland Contest'},
			{'value':'IARU-FIELD-DAY', 'meaning':'DARC IARU Region 1 Field Day'},
			{'value':'IARU-HF', 'meaning':'IARU HF World Championship'},
			{'value':'IA-QSO-PARTY', 'meaning':'Iowa QSO Party'},
			{'value':'ID-QSO-PARTY', 'meaning':'Idaho QSO Party'},
			{'value':'IL', 'meaning':'QSO Party       Illinois QSO Party'},
			{'value':'IN-QSO-PARTY', 'meaning':'Indiana QSO Party'},
			{'value':'JARTS-WW-RTTY', 'meaning':'JARTS WW RTTY'},
			{'value':'JIDX-CW', 'meaning':'Japan International DX Contest (CW)'},
			{'value':'JIDX-SSB', 'meaning':'Japan International DX Contest (SSB)'},
			{'value':'JT-DX-RTTY', 'meaning':'Mongolian RTTY DX Contest'},
			{'value':'KS-QSO-PARTY', 'meaning':'Kansas QSO Party'},
			{'value':'KY-QSO-PARTY', 'meaning':'Kentucky QSO Party'},
			{'value':'LA-QSO-PARTY', 'meaning':'Louisiana QSO Party'},
			{'value':'LDC-RTTY', 'meaning':'DRCG Long Distance Contest (RTTY)'},
			{'value':'LZ', 'meaning':'DX      LZ DX Contest'},
			{'value':'MAR-QSO-PARTY', 'meaning':'Maritimes QSO Party'},
			{'value':'MI-QSO-PARTY', 'meaning':'Michigan QSO Party'},
			{'value':'MIDATLANTIC-QSO-PARTY', 'meaning':'Mid-Atlantic QSO Party'},
			{'value':'MD-QSO-PARTY', 'meaning':'Maryland QSO Party'},
			{'value':'ME-QSO-PARTY', 'meaning':'Maine QSO Party'},
			{'value':'MI-QSO-PARTY', 'meaning':'Michigan QSO Party'},
			{'value':'MN-QSO-PARTY', 'meaning':'Minnesota QSO Party'},
			{'value':'MO-QSO-PARTY', 'meaning':'Missouri QSO Party'},
			{'value':'MS-QSO-PARTY', 'meaning':'Mississippi QSO Party'},
			{'value':'MT-QSO-PARTY', 'meaning':'Montana QSO Party'},
			{'value':'NAQP-CW', 'meaning':'North America QSO Party (CW)'},
			{'value':'NAQP-RTTY', 'meaning':'North America QSO Party (RTTY)'},
			{'value':'NAQP-SSB', 'meaning':'North America QSO Party (Phone)'},
			{'value':'NA-SPRINT-CW', 'meaning':'North America Sprint (CW)'},
			{'value':'NA-SPRINT-RTTY', 'meaning':'North America Sprint (RTTY)'},
			{'value':'NA-SPRINT-SSB', 'meaning':'North America Sprint (Phone)'},
			{'value':'NEQP', 'meaning':'New England QSO Party'},
			{'value':'NC-QSO-PARTY', 'meaning':'North Carolina QSO Party'},
			{'value':'ND-QSO-PARTY', 'meaning':'North Dakota QSO Party'},
			{'value':'NE-QSO-PARTY', 'meaning':'Nebraska QSO Party'},
			{'value':'NH-QSO-PARTY', 'meaning':'New Hampshire QSO Party'},
			{'value':'NJ-QSO-PARTY', 'meaning':'New Jersey QSO Party'},
			{'value':'NM-QSO-PARTY', 'meaning':'New Mexico QSO Party'},
			{'value':'NRAU-BALTIC-CW', 'meaning':'NRAU-Baltic Contest (CW)'},
			{'value':'NRAU-BALTIC-SSB', 'meaning':'NRAU-Baltic Contest (SSB)'},
			{'value':'NV-QSO-PARTY', 'meaning':'Nevada QSO Party'},
			{'value':'NY-QSO-PARTY', 'meaning':'New York QSO Party'},
			{'value':'OCEANIA-DX-CW', 'meaning':'Oceania DX Contest (CW)'},
			{'value':'OCEANIA-DX-SSB', 'meaning':'Oceania DX Contest (SSB)'},
			{'value':'OH-QSO-PARTY', 'meaning':'Ohio QSO Party'},
			{'value':'OK-DX-RTTY', 'meaning':'Czech Radio Club OK DX Contest'},
			{'value':'OK-OM-DX', 'meaning':'Czech Radio Club OK-OM DX Contest'},
			{'value':'OK-QSO-PARTY', 'meaning':'Oklahoma QSO Party'},
			{'value':'OMISS-QSO-PARTY', 'meaning':'Old Man International Sideband Society QSO Party'},
			{'value':'ON-QSO-PARTY', 'meaning':'Ontario QSO Party'},
			{'value':'OR-QSO-PARTY', 'meaning':'Oregon QSO Party'},
			{'value':'PACC', 'meaning':'Dutch PACC Contest'},
			{'value':'PA-QSO-PARTY', 'meaning':'Pennsylvania QSO Party'},
			{'value':'PSK-DEATHMATCH', 'meaning':'MDXA PSK DeathMatch (2005-2010)'},
			{'value':'QC-QSO-PARTY', 'meaning':'Quebec QSO Party'},
			{'value':'RAC', 'meaning':'Canadian Amateur Radio Society Contest'},
			{'value':'RAC-CANADA-DAY', 'meaning':'Canadian Amateur Radio Society Canada Day Contest'},
			{'value':'RAC-CANADA-WINTER', 'meaning':'Canadian Amateur Radio Society Canada Winter Contest'},
			{'value':'RDAC', 'meaning':'Russian District Award Contest'},
			{'value':'RDXC', 'meaning':'Russian DX Contest'},
			{'value':'REF-160M', 'meaning':'Reseau des Emetteurs Francais 160m Contest'},
			{'value':'REF-CW', 'meaning':'Reseau des Emetteurs Francais Contest (CW)'},
			{'value':'REF-SSB', 'meaning':'Reseau des Emetteurs Francais Contest (SSB)'},
			{'value':'RI-QSO-PARTY', 'meaning':'Rhode Island QSO Party'},
			{'value':'RSGB-160', 'meaning':'1.8Mhz Contest'},
			{'value':'RSGB-21/28-CW', 'meaning':'21/28 MHz Contest (CW)'},
			{'value':'RSGB-21/28-SSB', 'meaning':'21/28 MHz Contest (SSB)'},
			{'value':'RSGB-80M-CC', 'meaning':'80m Club Championships'},
			{'value':'RSGB-AFS-CW', 'meaning':'Affiliated Societies Team Contest (CW)'},
			{'value':'RSGB-AFS-SSB', 'meaning':'Affiliated Societies Team Contest (SSB)'},
			{'value':'RSGB-CLUB-CALLS', 'meaning':'Club Calls'},
			{'value':'RSGB-COMMONWEALTH', 'meaning':'Commonwealth Contest'},
			{'value':'RSGB-IOTA', 'meaning':'IOTA Contest'},
			{'value':'RSGB-LOW-POWER', 'meaning':'Low Power Field Day'},
			{'value':'RSGB-NFD', 'meaning':'National Field Day'},
			{'value':'RSGB-ROPOCO', 'meaning':'RoPoCo'},
			{'value':'RSGB-SSB-FD', 'meaning':'SSB Field Day'},
			{'value':'RUSSIAN-RTTY', 'meaning':'Russian Radio RTTY Worldwide Contest'},
			{'value':'SAC-CW', 'meaning':'Scandinavian Activity Contest (CW)'},
			{'value':'SAC-SSB', 'meaning':'Scandinavian Activity Contest (SSB)'},
			{'value':'SARTG-RTTY', 'meaning':'SARTG WW RTTY'},
			{'value':'SCC-RTTY', 'meaning':'SCC RTTY Championship'},
			{'value':'SC-QSO-PARTY', 'meaning':'South Carolina QSO Party'},
			{'value':'SD-QSO-PARTY', 'meaning':'South Dakota QSO Party'},
			{'value':'SMP-AUG', 'meaning':'SSA Portabeltest'},
			{'value':'SMP-MAY', 'meaning':'SSA Portabeltest'},
			{'value':'SPAR-WINTER-FD', 'meaning':'SPAR Winter Field Day'},
			{'value':'SPDXContest', 'meaning':'SP DX Contest'},
			{'value':'SP-DX-RTTY', 'meaning':'PRC SPDX Contest (RTTY)'},
			{'value':'Spring', 'meaning':'Sprint      FISTS Spring Sprint'},
			{'value':'SR-MARATHON', 'meaning':'Scottish-Russian Marathon'},
			{'value':'STEW-PERRY', 'meaning':'Stew Perry Topband Distance Challenge'},
			{'value':'Summer', 'meaning':'Sprint      FISTS Summer Sprint'},
			{'value':'TARA-GRID-DIP', 'meaning':'TARA Grid Dip PSK-RTTY Shindig'},
			{'value':'TARA-RTTY', 'meaning':'TARA RTTY M\xc3\xaal\xc3\xa9e'},
			{'value':'TARA-RUMBLE', 'meaning':'TARA Rumble PSK Contest'},
			{'value':'TARA-SKIRMISH', 'meaning':'TARA Skirmish Digital Prefix Contest'},
			{'value':'TEN-RTTY', 'meaning':'Ten-Meter RTTY Contest (before 2011)'},
			{'value':'TMC-RTTY', 'meaning':'The Makrothen Contest'},
			{'value':'TN-QSO-PARTY', 'meaning':'Tennessee QSO Party'},
			{'value':'TX-QSO-PARTY', 'meaning':'Texas QSO Party'},
			{'value':'UBA-DX-CW', 'meaning':'UBA Contest (CW)'},
			{'value':'UBA-DX-SSB', 'meaning':'UBA Contest (SSB)'},
			{'value':'UK-DX-BPSK63', 'meaning':'European PSK Club BPSK63 Contest'},
			{'value':'UK-DX-RTTY', 'meaning':'UK DX RTTY Contest'},
			{'value':'UKRAINIAN', 'meaning':'DX       Ukrainian DX'},
			{'value':'UKR-CHAMP-RTTY', 'meaning':'Open Ukraine RTTY Championship'},
			{'value':'UKSMG-6M-MARATHON', 'meaning':'UKSMG 6m Marathon'},
			{'value':'UKSMG-SUMMER-ES', 'meaning':'UKSMG Summer Es Contest'},
			{'value':'URE-DX', 'meaning':'Ukrainian DX Contest'},
			{'value':'US-COUNTIES-QSO', 'meaning':'Mobile Amateur Awards Club'},
			{'value':'UT-QSO-PARTY', 'meaning':'Utah QSO Party'},
			{'value':'VENEZ-IND-DAY', 'meaning':'RCV Venezuelan Independence Day Contest'},
			{'value':'Virginia', 'meaning':'QSO Party         Virginia QSO Party'},
			{'value':'VA-QSO-PARTY', 'meaning':'Virginia QSO Party'},
			{'value':'VOLTA-RTTY', 'meaning':'Alessandro Volta RTTY DX Contest'},
			{'value':'WA-QSO-PARTY', 'meaning':'Washington QSO Party'},
			{'value':'WI-QSO-PARTY', 'meaning':'Wisconsin QSO Party'},
			{'value':'WV-QSO-PARTY', 'meaning':'West Virginia QSO Party'},
			{'value':'WY-QSO-PARTY', 'meaning':'Wyoming QSO Party'},
			{'value':'Winter', 'meaning':'Sprint      FISTS Winter Sprint'},
			{'value':'XE-INTL-RTTY', 'meaning':'Mexico International Contest (RTTY)'},
			{'value':'YUDXC', 'meaning':'YU DX Contest'}
		]},
		'Credit':{'values':[
			{'value':'CQDX', 'meaning':'CQDX'},
			{'value':'CQDX_BAND', 'meaning':'CQDX_BAND'},
			{'value':'CQDX_MODE', 'meaning':'CQDX_MODE'},
			{'value':'CQDX_MOBILE', 'meaning':'CQDX_MOBILE'},
			{'value':'CQDX_QRP', 'meaning':'CQDX_QRP'},
			{'value':'CQDX_SATELLITE', 'meaning':'CQDX_SATELLITE'},
			{'value':'CQDXFIELD', 'meaning':'CQDXFIELD'},
			{'value':'CQDXFIELD_BAND', 'meaning':'CQDXFIELD_BAND'},
			{'value':'CQDXFIELD_MODE', 'meaning':'CQDXFIELD_MODE'},
			{'value':'CQDXFIELD_MOBILE', 'meaning':'CQDXFIELD_MOBILE'},
			{'value':'CQDXFIELD_QRP', 'meaning':'CQDXFIELD_QRP'},
			{'value':'CQDXFIELD_SATELLITE', 'meaning':'CQDXFIELD_SATELLITE'},
			{'value':'CQWAZ_MIXED', 'meaning':'CQWAZ_MIXED'},
			{'value':'CQWAZ_BAND', 'meaning':'CQWAZ_BAND'},
			{'value':'CQWAZ_MODE', 'meaning':'CQWAZ_MODE'},
			{'value':'CQWAZ_SATELLITE', 'meaning':'CQWAZ_SATELLITE'},
			{'value':'CQWAZ_EME', 'meaning':'CQWAZ_EME'},
			{'value':'CQWAZ_MOBILE', 'meaning':'CQWAZ_MOBILE'},
			{'value':'CQWAZ_QRP', 'meaning':'CQWAZ_QRP'},
			{'value':'CQWPX', 'meaning':'CQWPX'},
			{'value':'CQWPX_BAND', 'meaning':'CQWPX_BAND'},
			{'value':'CQWPX_MODE', 'meaning':'CQWPX_MODE'},
			{'value':'DXCC', 'meaning':'DXCC'},
			{'value':'DXCC_BAND', 'meaning':'DXCC_BAND'},
			{'value':'DXCC_MODE', 'meaning':'DXCC_MODE'},
			{'value':'DXCC_SATELLITE', 'meaning':'DXCC_SATELLITE'},
			{'value':'IOTA', 'meaning':'IOTA'},
			{'value':'RDA', 'meaning':'RDA'},
			{'value':'USACA', 'meaning':'USACA'},
			{'value':'VUCC_BAND', 'meaning':'VUCC_BAND'},
			{'value':'VUCC_SATELLITE', 'meaning':'VUCC_SATELLITE'},
			{'value':'WAB', 'meaning':'WAB'},
			{'value':'WAC', 'meaning':'WAC'},
			{'value':'WAC_BAND', 'meaning':'WAC_BAND'},
			{'value':'WAE', 'meaning':'WAE'},
			{'value':'WAE_BAND', 'meaning':'WAE_BAND'},
			{'value':'WAE_MODE', 'meaning':'WAE_MODE'},
			{'value':'WAIP', 'meaning':'WAIP'},
			{'value':'WAIP_BAND', 'meaning':'WAIP_BAND'},
			{'value':'WAIP_MODE', 'meaning':'WAIP_MODE'},
			{'value':'WAS', 'meaning':'WAS'},
			{'value':'WAS_BAND', 'meaning':'WAS_BAND'},
			{'value':'WAS_MODE', 'meaning':'WAS_MODE'},
			{'value':'WAS_SATELLITE', 'meaning':'WAS_SATELLITE'}
		]},
		'QSLSent':{values:[
			{'value':'Y', 'meaning':'yes (confirmed)'},
			{'value':'N', 'meaning':'no'},
			{'value':'R', 'meaning':'requested'},
			{'value':'Q', 'meaning':'queued'},
			{'value':'I', 'meaning':'ignore or invalid'}
		]},
		'QSLRcvd':{values:[
			{'value':'Y', 'meaning':'yes (confirmed)'},
			{'value':'N', 'meaning':'no'},
			{'value':'R', 'meaning':'requested'},
			{'value':'I', 'meaning':'ignore or invalid'},
			{'value':'V', 'meaning':'verified (deprecated)'}
		]},
		'Propagation':{values:[
			{'value':'AUR', 'meaning':'Aurora'},
			{'value':'AUE', 'meaning':'Aurora-E'},
			{'value':'BS', 'meaning':'Back scatter'},
			{'value':'ECH', 'meaning':'EchoLink'},
			{'value':'EME', 'meaning':'Earth-Moon-Earth'},
			{'value':'ES', 'meaning':'Sporadic E'},
			{'value':'FAI', 'meaning':'Field Aligned Irregularities'},
			{'value':'F2', 'meaning':'F2 Reflection'},
			{'value':'INTERNET', 'meaning':'Internet-assisted'},
			{'value':'ION', 'meaning':'Ionoscatter'},
			{'value':'IRL', 'meaning':'IRLP'},
			{'value':'MS', 'meaning':'Meteor scatter'},
			{'value':'RPT', 'meaning':'Terrestrial or atmospheric repeater or transponder'},
			{'value':'RS', 'meaning':'Rain scatter'},
			{'value':'SAT', 'meaning':'Satellite'},
			{'value':'TEP', 'meaning':'Trans-equatorial'},
			{'value':'TR', 'meaning':'Tropospheric ducting'}
		]},
		'QSLVia':{values:[
			{'value':'B', 'meaning':'bureau'},
			{'value':'D', 'meaning':'direct'},
			{'value':'E', 'meaning':'electronic'},
			{'value':'M', 'meaning':'manager (deprecated)'}
		]},
		'QSOComplete':{values:[
			{'value':'Y', 'meaning':'yes'},
			{'value':'N', 'meaning':'no'},
			{'value':'NIL', 'meaning':'not heard'},
			{'value':'?', 'meaning':'uncertain'}
		]},
	},

	fields : {
		'ADDRESS':	{'type':'MultilineString', 'desc':"the contacted station's complete mailing address: full name, street address, city, postal code, and country"},
		'ADDRESS_INTL':	{'type':'IntlMultilineString', 'desc':"the contacted station's complete mailing address: full name, street address, city, postal code, and country"},
		'AGE':	{'type':'Number', 'desc':"the contacted station's operator's age in years"},
		'A_INDEX':	{'type':'Number', 'desc':"the geomagnetic A index at the time of the QSO"},
		'ANT_AZ':	{'type':'Number', 'desc':"the logging station's antenna azimuth, in degrees"},
		'ANT_EL':	{'type':'Number', 'desc':"the logging station's antenna elevation, in degrees"},
		'ANT_PATH':	{'type':'Enumeration', 'desc':"the signal path"},
		'ARRL_SECT':	{'type':'Enumeration', 'desc':"the contacted station's ARRL section"},
		'AWARD_SUBMITTED':	{'type':'SponsoredAwardList', 'desc':"the list of awards submitted to a sponsor. note that this field might not be used in a QSO record.  It might be used to convey information about a user’s “Award Account” between an award sponsor and the user.  For example, AA6YQ might submit a request for DXCC awards by sending the following: <CALL:5>AA6YQ <AWARD_SUBMITTED:64>FISTS_CENTURY_BASIC,FISTS_CENTURY_SILVER,FISTS_SPECTRUM_100-160m"},
		'AWARD_GRANTED':	{'type':'SponsoredAwardList', 'desc':"the list of awards granted by a sponsor. note that this field might not be used in a QSO record.  It might be used to convey information about a user’s “Award Account” between an award sponsor and the user.  For example, in response to a request “send me a list of the DXCC awards granted to AA6YQ”, this might be received: <CALL:5>AA6YQ <AWARD_GRANTED:64>FISTS_CENTURY_BASIC,FISTS_CENTURY_SILVER, FISTS_SPECTRUM_100-160m"},
		'BAND':	{'type':'Enumeration', 'desc':"QSO Band"},
		'BAND_RX':	{'type':'Enumeration', 'desc':"in a split frequency QSO, the logging station's receiving band"},
		'CALL':	{'type':'String', 'desc':"the contacted station's Callsign"},
		'CHECK':	{'type':'String', 'desc':"contest check (e.g. for ARRL Sweepstakes)"},
		'CLASS':	{'type':'String', 'desc':"contest class (e.g. for ARRL Field Day)"},
		'CLUBLOG_QSO_UPLOAD_DATE':	{'type':'Date', 'desc':"the date the QSO was last uploaded to the Club Log online service"},
		'CLUBLOG_QSO_UPLOAD_STATUS':	{'type':'Enumeration', 'desc':"the upload status of the QSO on the Club Log online service"},
		'CNTY':	{'type':'OmniscientEnumeration', 'desc':"the contacted station's Secondary Administrative Subdivision of contacted station (e.g. US county, JA Gun), in the specified format"},
		'COMMENT':	{'type':'String', 'desc':"comment field for QSO"},
		'COMMENT_INTL':	{'type':'IntlString', 'desc':"comment field for QSO"},
		'CONT':	{'type':'Enumeration', 'desc':"the contacted station's Continent"},
		'CONTACTED_OP':	{'type':'String', 'desc':"the callsign of the individual operating the contacted station"},
		'CONTEST_ID':	{'type':'String', 'desc':"QSO Contest Identifier use enumeration values for interoperability"},
		'COUNTRY':	{'type':'String', 'desc':"the contacted station's DXCC entity name"},
		'COUNTRY_INTL':	{'type':'IntlString', 'desc':"the contacted station's DXCC entity name"},
		'CQZ':	{'type':'Number', 'desc':"the contacted station's CQ Zone"},
		'CREDIT_SUBMITTED':	{'type':'CreditList', 'desc':"the list of credits sought for this QSO"},
		'CREDIT_GRANTED':	{'type':'CreditList', 'desc':"the list of credits granted to this QSO"},
		'DISTANCE':	{'type':'Number', 'desc':"the distance between the logging station and the contacted station in kilometers via the specified signal path"},
		'DXCC':	{'type':'Enumeration', 'desc':"the contacted station's Country Code"},
		'EMAIL':	{'type':'String', 'desc':"the contacted station's email address"},
		'EQ_CALL':	{'type':'String', 'desc':"the contacted station's owner's callsign"},
		'EQSL_QSLRDATE':	{'type':'Date', 'desc':"date QSL received from eQSL.cc (only valid if EQSL_QSL_RCVD is Y, I, or V) (V deprecated)"},
		'EQSL_QSLSDATE':	{'type':'Date', 'desc':"date QSL sent to eQSL.cc (only valid if EQSL_QSL_SENT is Y, Q, or I)"},
		'EQSL_QSL_RCVD':	{'type':'Enumeration', 'desc':"eQSL.cc QSL received status instead of V (deprecated) use <CREDIT_GRANTED:39>DXCC:eqsl,DXCC_BAND:eqsl,DXCC_MODE:eqsl Default Value: N"},
		'EQSL_QSL_SENT':	{'type':'Enumeration', 'desc':"eQSL.cc QSL sent status Default Value: N"},
		'FISTS':	{'type':'String', 'desc':"the contacted station's FISTS CW Club member information, which starts with a sequence of Digits giving the member's number.  For upward-compatibility, any characters after the last digit of the member number sequence must be allowed by applications."},
		'FISTS_CC':	{'type':'String', 'desc':"the contacted station's FISTS CW Club Century Certificate (CC) number, which is a sequence of Digits only (no sign and no decimal point)"},
		'FORCE_INIT':	{'type':'Boolean', 'desc':'new EME"initial"'},
		'FREQ':	{'type':'Number', 'desc':"QSO frequency in Megahertz"},
		'FREQ_RX':	{'type':'Number', 'desc':"in a split frequency QSO, the logging station's receiving frequency in Megahertz"},
		'GRIDSQUARE': {'type':'GridSquare', 'desc':"the contacted station's 2-character, 4-character, 6-character, or 8-character Maidenhead Grid Square"},
		'GUEST_OP':	{'type':'String', 'desc':"deprecated: use OPERATOR instead"},
		'HRDLOG_QSO_UPLOAD_DATE':	{'type':'Date', 'desc':"the date the QSO was last uploaded to the HRDLog.net online service"},
		'HRDLOG_QSO_UPLOAD_STATUS':	{'type':'Enumeration', 'desc':"the upload status of the QSO on the HRDLog.net online service"},
		'IOTA':	{'type':'String', 'desc':"the contacted station's IOTA designator, in format CC-XXX, where CC is a member of the Continent enumeration XXX is the island designator, where 0 <= XXX ,<= 999 [use leading zeroes]"},
		'IOTA_ISLAND_ID':	{'type':'String', 'desc':"the contacted station's IOTA Island Identifier"},
		'ITUZ':	{'type':'Number', 'desc':"the contacted station's ITU zone"},
		'K_INDEX':	{'type':'Number', 'desc':"the geomagnetic K index at the time of the QSO"},
		'LAT':	{'type':'Location', 'desc':"the contacted station's latitude"},
		'LON':	{'type':'Location', 'desc':"the contacted station's longitude"},
		'LOTW_QSLRDATE':	{'type':'Date', 'desc':"date QSL received from ARRL Logbook of the World (only valid if LOTW_QSL_RCVD is Y, I, or V) (V deprecated)"},
		'LOTW_QSLSDATE':	{'type':'Date', 'desc':"date QSL sent to ARRL Logbook of the World (only valid if LOTW_QSL_SENT is Y, Q, or I)"},
		'LOTW_QSL_RCVD':	{'type':'Enumeration', 'desc':"ARRL Logbook of the World QSL received status instead of V (deprecated) use <CREDIT_GRANTED:39>DXCC:lotw,DXCC_BAND:lotw,DXCC_MODE:lotw Default Value: N"},
		'LOTW_QSL_SENT':	{'type':'Enumeration', 'desc':"ARRL Logbook of the World QSL sent status Default Value: N"},
		'MAX_BURSTS':	{'type':'Number', 'desc':"maximum length of meteor scatter bursts heard by the logging station, in seconds"},
		'MODE':	{'type':'Enumeration', 'desc':"QSO Mode"},
		'MS_SHOWER':	{'type':'String', 'desc':"For Meteor Scatter QSOs, the name of the meteor shower in progress"},
		'MY_CITY':	{'type':'String', 'desc':"the logging station's city"},
		'MY_CITY_INTL':	{'type':'IntlString', 'desc':"the logging station's city"},
		'MY_CNTY':	{'type':'OmniscientEnumeration', 'desc':"the logging station's Secondary Administrative Subdivision  (e.g. US county, JA Gun) , in the specified format"},
		'MY_COUNTRY':	{'type':'String', 'desc':"the logging station's DXCC entity name"},
		'MY_COUNTRY_INTL':	{'type':'IntlString', 'desc':"the logging station's DXCC entity name"},
		'MY_CQ_ZONE':	{'type':'Number', 'desc':"the logging station's CQ Zone"},
		'MY_DXCC':	{'type':'Enumeration', 'desc':"the logging station's Country Code"},
		'MY_FISTS':	{'type':'String', 'desc':"the logging station's FISTS CW Club member information, which starts with a sequence of Digits giving the member's number. For upward-compatibility, any characters after the last digit of the member number sequence must be allowed by applications."},
		'MY_GRIDSQUARE': {'type':'GridSquare', 'desc':"the logging station's 2-character, 4-character, 6-character, or 8-character Maidenhead Grid Square"},
		'MY_IOTA':	{'type':'String', 'desc':"the logging station's IOTA designator, in format CC-XXX, where CC is a member of the Continent enumeration XXX is the island designator, where 0 <= XXX ,<= 999  [use leading zeroes]"},
		'MY_IOTA_ISLAND_ID':	{'type':'String', 'desc':"the logging station's IOTA Island Identifier"},
		'MY_ITU_ZONE':	{'type':'Number', 'desc':"the logging station's ITU zone"},
		'MY_LAT':	{'type':'Location', 'desc':"the logging station's latitude"},
		'MY_LON':	{'type':'Location', 'desc':"the logging station's longitude"},
		'MY_NAME':	{'type':'String', 'desc':"the logging operator's name"},
		'MY_NAME_INTL':	{'type':'IntlString', 'desc':"the logging operator's name"},
		'MY_POSTAL_CODE':	{'type':'String', 'desc':"the logging station's postal code"},
		'MY_POSTAL_CODE_INTL':	{'type':'IntlString', 'desc':"the logging station's postal code"},
		'MY_RIG':	{'type':'String', 'desc':"description of the logging station's equipment"},
		'MY_RIG_INTL':	{'type':'IntlString', 'desc':"description of the logging station's equipment"},
		'MY_SIG':	{'type':'String', 'desc':"special interest activity or event"},
		'MY_SIG_INTL':	{'type':'IntlString', 'desc':"special interest activity or event"},
		'MY_SIG_INFO':	{'type':'String', 'desc':"special interest activity or event information"},
		'MY_SIG_INFO_INTL':	{'type':'IntlString', 'desc':"special interest activity or event information"},
		'MY_SOTA_REF':	{'type':'SOTARef', 'desc':"the logging station's International SOTA Reference."},
		'MY_STATE':	{'type':'OmniscientEnumeration', 'desc':"the code for the logging station's Primary Administrative Subdivision (e.g. US State, JA Island, VE Province)"},
		'MY_STREET':	{'type':'String', 'desc':"the logging station's street"},
		'MY_STREET_INTL':	{'type':'IntlString', 'desc':"the logging station's street"},
		'MY_USACA_COUNTIES':	{'type':'SecondarySubdivisionList', 'desc':"two US counties in the case where the logging station is located on a border between two counties, representing counties that the contacted station may claim for the CQ Magazine USA-CA award program.  E.g. MA,Franklin:MA,Hampshire"},
		'MY_VUCC_GRIDS': {'type':'GridSquareList', 'desc':"two or four adjacent Maidenhead grid locators, each four characters long, representing the logging station's grid squares that the contacted station may claim for the ARRL VUCC award program.  E.g. EN98,FM08,EM97,FM07"},
		'NAME':	{'type':'String', 'desc':"the contacted station's operator's name"},
		'NAME_INTL':	{'type':'IntlString', 'desc':"the contacted station's operator's name"},
		'NOTES':	{'type':'MultilineString', 'desc':"QSO notes"},
		'NOTES_INTL':	{'type':'IntlMultilineString', 'desc':"QSO notes"},
		'NR_BURSTS':	{'type':'Number', 'desc':"the number of meteor scatter bursts heard by the logging station"},
		'NR_PINGS':	{'type':'Number', 'desc':"the number of meteor scatter pings heard by the logging station"},
		'OPERATOR':	{'type':'String', 'desc':"the logging operator's callsign if STATION_CALLSIGN is absent, OPERATOR shall be treated as both the logging station's callsign and the logging operator's callsign"},
		'OWNER_CALLSIGN':	{'type':'String', 'desc':"the callsign of the owner of the station used to log the contact (the callsign of the OPERATOR's host) if OWNER_CALLSIGN is absent, STATION_CALLSIGN shall be treated as both the logging station's callsign and the callsign of the owner of the station"},
		'PFX':	{'type':'String', 'desc':"the contacted station's WPX prefix"},
		'PRECEDENCE':	{'type':'String', 'desc':"contest precedence (e.g. for ARRL Sweepstakes)"},
		'PROP_MODE':	{'type':'Enumeration', 'desc':"QSO propagation mode"},
		'PUBLIC_KEY':	{'type':'String', 'desc':"public encryption key"},
		'QRZCOM_QSO_UPLOAD_DATE':	{'type':'Date', 'desc':"the date the QSO was last uploaded to the QRZ.COM online service"},
		'QRZCOM_QSO_UPLOAD_STATUS':	{'type':'Enumeration', 'desc':"the upload status of the QSO on the QRZ.COM online service"},
		'QSLMSG':	{'type':'MultilineString', 'desc':"QSL card message"},
		'QSLMSG_INTL':	{'type':'IntlMultilineString', 'desc':"QSL card message"},
		'QSLRDATE':	{'type':'Date', 'desc':"QSL received date (only valid if QSL_RCVD is Y, I, or V) (V deprecated)"},
		'QSLSDATE':	{'type':'Date', 'desc':"QSL sent date (only valid if QSL_SENT is Y, Q, or I)"},
		'QSL_RCVD':	{'type':'Enumeration', 'desc':"QSL received status instead of V (deprecated) use <CREDIT_GRANTED:39>DXCC:card,DXCC_BAND:card,DXCC_MODE:card Default Value: N"},
		'QSL_RCVD_VIA':	{'type':'Enumeration', 'desc':"means by which the QSL was received by the logging station use of M (manager) is deprecated"},
		'QSL_SENT':	{'type':'Enumeration', 'desc':"QSL sent status Default Value: N"},
		'QSL_SENT_VIA':	{'type':'Enumeration', 'desc':"means by which the QSL was sent by the logging station use of M (manager) is deprecated"},
		'QSL_VIA':	{'type':'String', 'desc':"the contacted station's QSL route"},
		'QSO_COMPLETE':	{'type':'Enumeration', 'desc':"indicates whether the QSO was complete from the perspective of the logging station Y - yes N - no NIL - not heard ? - uncertain"},
		'QSO_DATE':	{'type':'Date', 'desc':"date on which the QSO started"},
		'QSO_DATE_OFF':	{'type':'Date', 'desc':"date on which the QSO ended"},
		'QSO_RANDOM':	{'type':'Boolean', 'desc':"indicates whether the QSO was random or scheduled"},
		'QTH':	{'type':'String', 'desc':"the contacted station's city"},
		'QTH_INTL':	{'type':'IntlString', 'desc':"the contacted station's city"},
		'RIG':	{'type':'MultilineString', 'desc':"description of the contacted station's equipment"},
		'RIG_INTL':	{'type':'IntlMultilineString', 'desc':"description of the contacted station's equipment"},
		'RST_RCVD':	{'type':'String', 'desc':"signal report from the contacted station"},
		'RST_SENT':	{'type':'String', 'desc':"signal report sent to the contacted station"},
		'RX_PWR':	{'type':'Number', 'desc':"the contacted station's transmitter power in watts"},
		'SAT_MODE':	{'type':'String', 'desc':"satellite mode"},
		'SAT_NAME':	{'type':'String', 'desc':"name of satellite"},
		'SFI':	{'type':'Number', 'desc':"the solar flux at the time of the QSO"},
		'SIG':	{'type':'String', 'desc':"the name of the contacted station's special activity or interest group"},
		'SIG_INTL':	{'type':'IntlString', 'desc':"the name of the contacted station's special activity or interest group"},
		'SIG_INFO':	{'type':'String', 'desc':"information associated with the contacted station's activity or interest group"},
		'SIG_INFO_INTL':	{'type':'IntlString', 'desc':"information associated with the contacted station's activity or interest group"},
		'SKCC':	{'type':'String', 'desc':"the contacted station's Straight Key Century Club (SKCC) member information"},
		'SOTA_REF':	{'type':'SOTARef', 'desc':"the contacted station's International SOTA Reference."},
		'SRX':	{'type':'Number', 'desc':"contest QSO received serial number"},
		'SRX_STRING':	{'type':'String', 'desc':"contest QSO received information use Cabrillo format to convey contest information for which ADIF fields are not specified in the event of a conflict between information in a dedicated contest field and this field, information in the dedicated contest field shall prevail"},
		'STATE':	{'type':'OmniscientEnumeration', 'desc':"the code for the contacted station's Primary Administrative Subdivision (e.g. US State, JA Island, VE Province)"},
		'STATION_CALLSIGN':	{'type':'String', 'desc':"the logging station's callsign (the callsign used over the air) if STATION_CALLSIGN is absent, OPERATOR shall be treated as both the logging station's callsign and the logging operator's callsign"},
		'STX':	{'type':'Number', 'desc':"contest QSO transmitted serial number"},
		'STX_STRING':	{'type':'String', 'desc':"contest QSO transmitted information use Cabrillo format to convey contest information for which ADIF fields are not specified in the event of a conflict between information in a dedicated contest field and this field, information in the dedicated contest field shall prevail"},
		'SUBMODE':	{'type':'Enumeration', 'desc':"QSO Submode use enumeration values for interoperability"},
		'SWL':	{'type':'Boolean', 'desc':"indicates that the QSO information pertains to an SWL report"},
		'TEN_TEN':	{'type':'Number', 'desc':"Ten-Ten number"},
		'TIME_OFF':	{'type':'Time', 'desc':"HHMM or HHMMSS in UTC in the absence of <QSO_DATE_OFF>, the QSO duration is less than 24 hours"},
		'TIME_ON':	{'type':'Time', 'desc':"HHMM or HHMMSS in UTC"},
		'TX_PWR':	{'type':'Number', 'desc':"the logging station's power in watts"},
		'USACA_COUNTIES':	{'type':'SecondarySubdivisionList', 'desc':"two US counties in the case where the contacted station is located on a border between two counties, representing counties credited to the QSO for the CQ Magazine USA-CA award program.  E.g. MA,Franklin:MA,Hampshire"},
		'VE_PROV':	{'type':'String', 'desc':"deprecated: use State instead"},
		'VUCC_GRIDS':	{'type':'GridSquareList', 'desc':"two or four adjacent Maidenhead grid locators, each four characters long, representing the contacted station's grid squares credited to the QSO for the ARRL VUCC award program.  E.g. EN98,FM08,EM97,FM07"},
		'WEB':	{'type':'String', 'desc':"the contacted station's URL"},
	}
};
ADIF_specification.fields.ANT_PATH.enumeration=ADIF_specification.enumerations.AntPath;
ADIF_specification.fields.ARRL_SECT.enumeration=ADIF_specification.enumerations.ARRLSection;
ADIF_specification.fields.BAND.enumeration=ADIF_specification.enumerations.Band;
ADIF_specification.fields.BAND_RX.enumeration=ADIF_specification.enumerations.Band;
ADIF_specification.fields.CLUBLOG_QSO_UPLOAD_STATUS.enumeration=ADIF_specification.enumerations.QSOUploadStatus;
ADIF_specification.fields.CONT.enumeration=ADIF_specification.enumerations.Continent;
ADIF_specification.fields.CONTEST_ID.enumeration=ADIF_specification.enumerations.ContestID;
ADIF_specification.fields.CREDIT_SUBMITTED.enumeration=ADIF_specification.enumerations.Credit;
ADIF_specification.fields.CREDIT_GRANTED.enumeration=ADIF_specification.enumerations.Credit;
ADIF_specification.fields.DXCC.enumeration=ADIF_specification.enumerations.CountryCode;
ADIF_specification.fields.EQSL_QSL_RCVD.enumeration=ADIF_specification.enumerations.QSLRcvd;
ADIF_specification.fields.EQSL_QSL_SENT.enumeration=ADIF_specification.enumerations.QSLSent;
ADIF_specification.fields.HRDLOG_QSO_UPLOAD_STATUS.enumeration=ADIF_specification.enumerations.QSOUploadStatus;
ADIF_specification.fields.LOTW_QSL_RCVD.enumeration=ADIF_specification.enumerations.QSLRcvd;
ADIF_specification.fields.LOTW_QSL_SENT.enumeration=ADIF_specification.enumerations.QSLSent;
ADIF_specification.fields.MODE.enumeration=ADIF_specification.enumerations.Mode;
ADIF_specification.fields.MY_DXCC.enumeration=ADIF_specification.enumerations.CountryCode;
ADIF_specification.fields.PROP_MODE.enumeration=ADIF_specification.enumerations.Propagation;
ADIF_specification.fields.QRZCOM_QSO_UPLOAD_STATUS.enumeration=ADIF_specification.enumerations.QSOUploadStatus;
ADIF_specification.fields.QSL_RCVD.enumeration=ADIF_specification.enumerations.QSLRcvd;
ADIF_specification.fields.QSL_RCVD_VIA.enumeration=ADIF_specification.enumerations.QSLVia;
ADIF_specification.fields.QSL_SENT.enumeration=ADIF_specification.enumerations.QSLSent;
ADIF_specification.fields.QSL_SENT_VIA.enumeration=ADIF_specification.enumerations.QSLVia;
ADIF_specification.fields.QSO_COMPLETE.enumeration=ADIF_specification.enumerations.QSOComplete;
ADIF_specification.fields.SUBMODE.enumeration=ADIF_specification.enumerations.Submode;

function ADIF_Log(app_name, path)
{
	this.app_name = app_name;
	if(this.app_name==undefined)
		this.app_name = 'The Nameless App';
	if(path != undefined) {
		import_log(path);
	}
}

