/* Single byte instructions */

const CS_IF_TRUE=0;			/* Same as IF_EQUAL */
const CS_IF_FALSE=1;			/* Same as IF_NOT_EQUAL */
const CS_ELSE=2;
const CS_ENDIF=3;
const CS_CMD_HOME=4;
const CS_CMD_POP=5;
const CS_END_CMD=6;
const CS_RETURN=7;
const CS_GETKEY=8;
const CS_GETKEYE=9;
const CS_UNGETKEY=10;
const CS_UNGETSTR=11;
const CS_PRINTKEY=12;
const CS_PRINTSTR=13;
const CS_HANGUP=14;
const CS_SYNC=15;
const CS_ASYNC=16;
const CS_CHKSYSPASS=17;
const CS_LOGKEY=18;
const CS_LOGKEY_COMMA=19;
const CS_LOGSTR=20;
const CS_CLS=21;
const CS_CRLF=22;
const CS_PAUSE=23;
const CS_PAUSE_RESET=24;
const CS_GETLINES=25;
const CS_GETFILESPEC=26;
const CS_FINDUSER=27;
const CS_CLEAR_ABORT=28;
const CS_SELECT_SHELL=29;
const CS_SET_SHELL=30;
const CS_SELECT_EDITOR=31;
const CS_SET_EDITOR=32;			/* 0x20 */
const CS_INKEY=33;
const CS_INCHAR=34;				/* Was RIOSYNC (now deprecated) 02/18/01 */
const CS_GETTIMELEFT=35;
const CS_SAVELINE=36;
const CS_RESTORELINE=37;
const CS_IF_GREATER=38;
const CS_IF_GREATER_OR_EQUAL=39;
const CS_IF_LESS=40;
const CS_IF_LESS_OR_EQUAL=41;
const CS_DEFAULT=42; 			/* 0x2a */
const CS_END_SWITCH=43;
const CS_END_CASE=44;
const CS_PUT_NODE=45;
const CS_GETCHAR=46;
const CS_ONE_MORE_BYTE=47;

/* Two byte instructions */

const CS_CMDKEY=48;
const CS_NODE_ACTION=49;
const CS_GETSTR=50;
const CS_GETNAME=51;
const CS_GETSTRUPR=52;
const CS_SHIFT_STR=53;
const CS_COMPARE_KEY=54;
const CS_SETLOGIC=55;
const CS_SET_USER_LEVEL=56;
const CS_SET_USER_STRING=57;
const CS_GETLINE=58; 			/* 0x3a */
const CS_NODE_STATUS=59;
const CS_CMDCHAR=60;
const CS_COMPARE_CHAR=61;
const CS_MULTINODE_CHAT=62;
const CS_TWO_MORE_BYTES=63;

/* Three byte instructions */

const CS_GOTO=64;
const CS_CALL=65;
const CS_TOGGLE_NODE_MISC=66;
const CS_ADJUST_USER_CREDITS=67;
const CS_TOGGLE_USER_FLAG=68;
const CS_GETNUM=69;
const CS_COMPARE_NODE_MISC=70;
const CS_MSWAIT=71;
const CS_ADJUST_USER_MINUTES=72;
const CS_REVERT_TEXT=73;
const CS_THREE_MORE_BYTES=79;

/* String arg instructions */

const CS_MENU=80;
const CS_PRINT=81;
const CS_PRINT_LOCAL=82;
const CS_PRINT_REMOTE=83;
const CS_PRINTFILE=84;
const CS_PRINTFILE_LOCAL=85;
const CS_PRINTFILE_REMOTE=86;
const CS_YES_NO=87;
const CS_NO_YES=88;
const CS_COMPARE_STR=89;
const CS_COMPARE_WORD=90;		/* 0x5a */
const CS_EXEC=91;
const CS_EXEC_INT=92;
const CS_EXEC_BIN=93;
const CS_EXEC_XTRN=94;
const CS_GETCMD=95;
const CS_LOG=96; 				/* 0x60 */
const CS_MNEMONICS=97;
const CS_SETSTR=98;
const CS_SET_MENU_DIR=99;
const CS_SET_MENU_FILE=100;
const CS_CMDSTR=101;
const CS_CHKFILE=102;
const CS_GET_TEMPLATE=103;
const CS_TRASHCAN=104;
const CS_CREATE_SIF=105;
const CS_READ_SIF=106;			/* 0x6a */
const CS_CMDKEYS=107;
const CS_COMPARE_KEYS=108;
const CS_STR_FUNCTION=111;

/* Var length instructions */

const CS_COMPARE_ARS=112;
const CS_TOGGLE_USER_MISC=113;
const CS_COMPARE_USER_MISC=114;
const CS_REPLACE_TEXT=115;
const CS_TOGGLE_USER_CHAT=116;
const CS_COMPARE_USER_CHAT=117;
const CS_TOGGLE_USER_QWK=118;
const CS_COMPARE_USER_QWK=119;
const CS_SWITCH=120;
const CS_CASE=121;
const CS_USE_INT_VAR=122; 		/* 0x7a */

/* Network (TCP/IP) Functions */

const CS_NET_FUNCTION=125;

/* File I/O Functions */

const CS_FIO_FUNCTION=126;

/* Variable instruction sub-ops */

const CS_VAR_INSTRUCTION=127;

/* Functions */

const CS_MAIL_READ=128;
const CS_MAIL_READ_SENT=129;
const CS_MAIL_READ_ALL=130;
const CS_MAIL_SEND=131;
const CS_MAIL_SEND_BULK=132;
const CS_MAIL_SEND_FILE=133;
const CS_MAIL_SEND_FEEDBACK=134;
const CS_MAIL_SEND_NETMAIL=135;
const CS_MAIL_SEND_NETFILE=136;
const CS_LOGOFF=137;
const CS_LOGOFF_FAST=138;
const CS_AUTO_MESSAGE=139;
const CS_MSG_SET_AREA=140;
const CS_MSG_SELECT_AREA=141;
const CS_MSG_SHOW_GROUPS=142;
const CS_MSG_SHOW_SUBBOARDS=143;
const CS_MSG_GROUP_UP=144;			/* 0x90 */
const CS_MSG_GROUP_DOWN=145;
const CS_MSG_SUBBOARD_UP=146;
const CS_MSG_SUBBOARD_DOWN=147;
const CS_MSG_GET_SUB_NUM=148;
const CS_MSG_GET_GRP_NUM=149;
const CS_MSG_READ=150;
const CS_MSG_POST=151;
const CS_MSG_QWK=152;
const CS_MSG_PTRS_CFG=153;
const CS_MSG_PTRS_REINIT=154;
const CS_MSG_NEW_SCAN_CFG=155;
const CS_MSG_NEW_SCAN=156;
const CS_MSG_NEW_SCAN_ALL=157;
const CS_MSG_CONT_SCAN=158;
const CS_MSG_CONT_SCAN_ALL=159;
const CS_MSG_BROWSE_SCAN=160; 		/* 0xA0 */
const CS_MSG_BROWSE_SCAN_ALL=161;
const CS_MSG_FIND_TEXT=162;
const CS_MSG_FIND_TEXT_ALL=163;
const CS_MSG_YOUR_SCAN_CFG=164;
const CS_MSG_YOUR_SCAN=165;
const CS_MSG_YOUR_SCAN_ALL=166;
const CS_MSG_NEW_SCAN_SUB=167;
const CS_MSG_SET_GROUP=168;
const CS_MSG_UNUSED4=169;
const CS_MSG_UNUSED3=170;
const CS_MSG_UNUSED2=171;
const CS_MSG_UNUSED1=172;
const CS_FILE_SET_AREA=173;
const CS_FILE_SELECT_AREA=174;
const CS_FILE_SHOW_LIBRARIES=175;
const CS_FILE_SHOW_DIRECTORIES=176;	/* 0xB0 */
const CS_FILE_LIBRARY_UP=177;
const CS_FILE_LIBRARY_DOWN=178;
const CS_FILE_DIRECTORY_UP=179;
const CS_FILE_DIRECTORY_DOWN=180;
const CS_FILE_GET_DIR_NUM=181;
const CS_FILE_GET_LIB_NUM=182;
const CS_FILE_LIST=183;
const CS_FILE_LIST_EXTENDED=184;
const CS_FILE_VIEW=185;
const CS_FILE_UPLOAD=186;
const CS_FILE_UPLOAD_USER=187;
const CS_FILE_UPLOAD_SYSOP=188;
const CS_FILE_DOWNLOAD=189;
const CS_FILE_DOWNLOAD_USER=190;
const CS_FILE_DOWNLOAD_BATCH=191;
const CS_FILE_REMOVE=192; 			/* 0xC0 */
const CS_FILE_BATCH_SECTION=193;
const CS_FILE_TEMP_SECTION=194;
const CS_FILE_NEW_SCAN_CFG=195;
const CS_FILE_NEW_SCAN=196;
const CS_FILE_NEW_SCAN_ALL=197;
const CS_FILE_FIND_TEXT=198;
const CS_FILE_FIND_TEXT_ALL=199;
const CS_FILE_FIND_NAME=200;
const CS_FILE_FIND_NAME_ALL=201;
const CS_FILE_PTRS_CFG=202;
const CS_FILE_BATCH_ADD=203;
const CS_FILE_BATCH_CLEAR=204;
const CS_FILE_SET_LIBRARY=205;
const CS_FILE_SEND=206;				/* Like file_get, but no password needed */
const CS_FILE_BATCH_ADD_LIST=207;
const CS_FILE_RECEIVE=208;			/* 0xD0 */
const CS_NODELIST_ALL=209;
const CS_NODELIST_USERS=210;
const CS_CHAT_SECTION=211;
const CS_USER_DEFAULTS=212;
const CS_USER_EDIT=213;
const CS_TEXT_FILE_SECTION=214;
const CS_INFO_SYSTEM=215;
const CS_INFO_SUBBOARD=216;
const CS_INFO_DIRECTORY=217;
const CS_INFO_USER=218;
const CS_INFO_VERSION=219;
const CS_INFO_XFER_POLICY=220;
const CS_XTRN_EXEC=221;
const CS_XTRN_SECTION=222;
const CS_USERLIST_SUB=223;
const CS_USERLIST_DIR=224;			/* 0xE0 */
const CS_USERLIST_ALL=225;
const CS_USERLIST_LOGONS=226;
const CS_PAGE_SYSOP=227;
const CS_PRIVATE_CHAT=228;
const CS_PRIVATE_MESSAGE=229;
const CS_MINUTE_BANK=230;
const CS_GURU_LOG=231;
const CS_ERROR_LOG=232;
const CS_SYSTEM_LOG=233;
const CS_SYSTEM_YLOG=234;
const CS_SYSTEM_STATS=235;
const CS_NODE_STATS=236;
const CS_SHOW_MEM=237;
const CS_CHANGE_USER=238;
const CS_ANSI_CAPTURE=239;
const CS_LIST_TEXT_FILE=240;			/* 0xF0 */
const CS_EDIT_TEXT_FILE=241;
const CS_FILE_SET_ALT_PATH=242;
const CS_FILE_RESORT_DIRECTORY=243;
const CS_FILE_GET=244;
const CS_FILE_PUT=245;
const CS_FILE_UPLOAD_BULK=246;
const CS_FILE_FIND_OLD=247;
const CS_FILE_FIND_OPEN=248;
const CS_FILE_FIND_OFFLINE=249;
const CS_FILE_FIND_OLD_UPLOADS=250;
const CS_INC_MAIN_CMDS=251;
const CS_INC_FILE_CMDS=252;
const CS_PRINTFILE_STR=253;
const CS_PAGE_GURU=254;				
const CS_SPY=255;						/* 0xFF */
	

/* Variable instructions (sub-op-code) */
/* Preceeded by CS_VAR_INSTRUCTION */
const SHOW_VARS=0;						/* Show all variables */
const PRINT_VAR=1;						/* Print a single variable */
const VAR_PRINTF=2; 					/* Print a formated line of text */
const VAR_PRINTF_LOCAL=3;				/* Print a formated line of text to local display */
const VAR_RESERVED_3=4;
const VAR_RESERVED_2=5;
const VAR_RESERVED_1=6;
const DEFINE_STR_VAR=7; 				/* Define Local Variable */
const DEFINE_INT_VAR=8;
const VAR_RESERVED_A4=9;
const VAR_RESERVED_A3=10;
const VAR_RESERVED_A2=11;
const VAR_RESERVED_A1=12;
const DEFINE_GLOBAL_STR_VAR=13;			/* Define Global Variable */
const DEFINE_GLOBAL_INT_VAR=14;
const VAR_RESERVED_B4=15;
const VAR_RESERVED_B3=16;	/* 0x10 */
const VAR_RESERVED_B2=17;
const VAR_RESERVED_B1=18;
const SET_STR_VAR=19;					/* Set string variable */
const SET_INT_VAR=20;					/* Set integer variable */
const VAR_RESERVED_C4=21;
const VAR_RESERVED_C3=22;
const VAR_RESERVED_C2=23;
const VAR_RESERVED_C1=24;
const COMPARE_STR_VAR=25;				/* Compare string variable (static) */
const COMPARE_INT_VAR=26;				/* Compare integer variable (static) */
const STRNCMP_VAR=27;					/* Compare n chars of str var (static) */
const STRSTR_VAR=28; 					/* Sub-string compare of str var (static) */
const VAR_RESERVED_D2=29;
const VAR_RESERVED_D1=30;
const COMPARE_VARS=31;					/* Compare two variables */
const STRNCMP_VARS=32;		/* 0x20 	// Compare n chars of str vars (dynamic) */
const STRSTR_VARS=33;					/* Sub-string compare between two str vars */
const VAR_RESERVED_E2=34;
const VAR_RESERVED_E1=35;
const COPY_VAR=36;						/* Copy from one variable to another */
const VAR_RESERVED_F4=37;
const VAR_RESERVED_F3=38;
const VAR_RESERVED_F2=39;
const VAR_RESERVED_F1=40;
const SWAP_VARS=41;						/* Swap two variables */
const VAR_RESERVED_G4=42;
const VAR_RESERVED_G3=43;
const VAR_RESERVED_G2=44;
const VAR_RESERVED_G1=45;
const CAT_STR_VAR=46;					/* Concatenate string variable (static) */
const CAT_STR_VARS=47;                   /* Concatenate strint variable (dynamic) */
const FORMAT_STR_VAR=48; 	/* 0x30 	// Format string variable */
const TIME_STR=49;						/* Write formated date/time to string */
const DATE_STR=50;						/* Write MM/DD/YY to string */
const FORMAT_TIME_STR=51;				/* Create custom date/time string */
const SECOND_STR=52; 					/* Create a string in format hh:mm:ss */
const STRUPR_VAR=53; 					/* Convert string to upper case */
const STRLWR_VAR=54; 					/* Convert string to lower case */
const ADD_INT_VAR=55;					/* Add to int variable (static) */
const ADD_INT_VARS=56;					/* Add to int variable (dynamic) */
const VAR_RESERVED_I4=57;
const VAR_RESERVED_I3=58;
const VAR_RESERVED_I2=59;
const VAR_RESERVED_I1=60;
const SUB_INT_VAR=61;					/* Subtract from int variable (static) */
const SUB_INT_VARS=62;					/* Subtract from int variable (dynamic) */
const VAR_RESERVED_J4=63;
const VAR_RESERVED_J3=64;	/* 0x40 */
const VAR_RESERVED_J2=65;
const VAR_RESERVED_J1=66;
const MUL_INT_VAR=67;					/* Multiply int variable (static) */
const MUL_INT_VARS=68;					/* Multiply int variable (dynamic) */
const VAR_RESERVED_K4=69;
const VAR_RESERVED_K3=70;
const VAR_RESERVED_K2=71;
const VAR_RESERVED_K1=72;
const DIV_INT_VAR=73;					/* Divide int variable (static) */
const DIV_INT_VARS=74;					/* Divide int variable (dynamic) */
const MOD_INT_VAR=75;
const MOD_INT_VARS=76;
const VAR_RESERVED_L2=77;
const VAR_RESERVED_L1=78;
const AND_INT_VAR=79;					/* Bit-wise AND int variable (static) */
const AND_INT_VARS=80;		/* 0x50 	// Bit-wise AND int variable (dynamic) */
const COMPARE_ANY_BITS=81;
const COMPARE_ALL_BITS=82;
const VAR_RESERVED_M2=83;
const VAR_RESERVED_M1=84;
const OR_INT_VAR=85; 					/* Bit-wise OR int variable (static) */
const OR_INT_VARS=86;					/* Bit-wise OR int variable (dynamic) */
const VAR_RESERVED_N4=87;
const VAR_RESERVED_N3=88;
const VAR_RESERVED_N2=89;
const VAR_RESERVED_N1=90;
const NOT_INT_VAR=91;					/* Bit-wise NOT int variable (static) */
const NOT_INT_VARS=92;					/* Bit-wise NOT int variable (dynamic) */
const VAR_RESERVED_O4=93;
const VAR_RESERVED_O3=94;
const VAR_RESERVED_O2=95;
const VAR_RESERVED_O1=96;	/* 0x60 */
const XOR_INT_VAR=97;					/* XOR int variable (static) */
const XOR_INT_VARS=98;					/* XOR int variable (dynamic) */
const VAR_RESERVED_P4=99;
const VAR_RESERVED_P3=100;
const VAR_RESERVED_P2=101;
const VAR_RESERVED_P1=102;
const RANDOM_INT_VAR=103; 				/* Set integer to random number */
const TIME_INT_VAR=104;					/* Set integer to current time/date */
const DATE_STR_TO_INT=105;				/* Convert a date string to integer */
const STRLEN_INT_VAR=106; 				/* Set integer to length of str */
const CRC16_TO_INT=107;					/* Get CRC-16 of str var */
const CRC32_TO_INT=108;					/* Get CRC-32 of str var */
const FLENGTH_TO_INT=109; 				/* Put length of str var file into int */
const CHARVAL_TO_INT=110; 				/* Put character val of str var into int */
const GETNUM_VAR=111; 					/* Get number */
const GETSTR_VAR=112; 		/* 0x70 	// Get string */
const GETNAME_VAR=113;					/* Get string (upper/lower) */
const GETSTRUPR_VAR=114;					/* Get string (upper) */
const GETLINE_VAR=115;					/* Get string (input bar/line) */
const SHIFT_STR_VAR=116;					/* Shift str in variable */
const GETSTR_MODE=117;					/* Get string with various modes */
const TRUNCSP_STR_VAR=118;				/* Truncate space off end of str var */
const CHKFILE_VAR=119;
const PRINTFILE_VAR_MODE=120; 			/* Printfile str var with mode */
const PRINTTAIL_VAR_MODE=121; 			/* Print tail-end of str var with mode */
const CHKSUM_TO_INT=122;					/* Get CHKSUM of str var */
const STRIP_CTRL_STR_VAR=123; 			/* Strip ctrl chars from str var */
const SEND_FILE_VIA=124;					/* Send file (static) via protocol */
const SEND_FILE_VIA_VAR=125;				/* Send file (dynamic) via protocol */
const FTIME_TO_INT=126;					/* Put time of str var file into int */
const RECEIVE_FILE_VIA=127;				/* Receive file (static) via protocol */
const RECEIVE_FILE_VIA_VAR=128; /* 0x80	// Receive file (dynamic) via protocol */
const TELNET_GATE_STR=129;				/* Run telnet gateway to static address with mode */
const TELNET_GATE_VAR=130;				/* Run telnet gateway to variable address with mode */
const COPY_FIRST_CHAR=131;				/* Copy first char of str var to int var */
const COMPARE_FIRST_CHAR=132;				/* Compare first char of str var to static char */
const COPY_CHAR=133;						/* Copy cmdkey to int var or str var */
const SHIFT_TO_FIRST_CHAR=134;			/* Shift str var to first occurance of static char */
const SHIFT_TO_LAST_CHAR=135;				/* Shift str var to last occurance of static char */
const MATCHUSER=136;						/* Set int var to user number of user name (str var) */

/* Preceeded by CS_STR_FUNCTION */
const CS_LOGIN=0;						/* Login/password prompt */
const CS_LOAD_TEXT=1;					/* Load alternative TEXT.DAT */

/* Preceeded by CS_ONE_MORE_BYTE */
const CS_ONLINE=0;						/* Online execution only */
const CS_OFFLINE=1; 					/* Offline execution allowed */
const CS_NEWUSER=2; 					/* New user procedure */
const CS_LOGON=3;						/* Logon procedure */
const CS_LOGOUT=4;						/* Logout procedure */
const CS_EXIT=5;						/* Exit current module immediately */
const CS_LOOP_BEGIN=6;					/* Looping anchor */
const CS_CONTINUE_LOOP=7;				/* "next" loop */
const CS_BREAK_LOOP=8;					/* Stop executing loop */
const CS_END_LOOP=9;					/* End of looping code block */

/* Preceeded by CS_TWO_MORE_BYTES */
const CS_USER_EVENT=0;					/* External user event */

/* Preceeded by CS_NET_FUNCTION */
const CS_SOCKET_OPEN=0;					/* Open a socket */
const CS_SOCKET_CLOSE=1;				/* Close a socket */
const CS_SOCKET_CONNECT=2;				/* Outbound connection */
const CS_SOCKET_ACCEPT=3;				/* Accept an incomming connection */
const CS_SOCKET_NREAD=4;				/* Get number of bytes in input buffer */
const CS_SOCKET_PEEK=5;					/* Peek at input buffer */
const CS_SOCKET_READ=6;					/* Read input buffer */
const CS_SOCKET_WRITE=7;				/* Write to socket */
const CS_SOCKET_CHECK=8;				/* Check connection */
const CS_SOCKET_READLINE=9;				/* Read a cr/lf delimited line from socket */
const CS_SOCKET_UNUSED6=10;
const CS_SOCKET_UNUSED5=11;
const CS_SOCKET_UNUSED4=12;
const CS_SOCKET_UNUSED3=13;
const CS_SOCKET_UNUSED2=14;
const CS_SOCKET_UNUSED1=15;

const CS_FTP_LOGIN=16;					/* socket, username, password */
const CS_FTP_LOGOUT=17;
const CS_FTP_PWD=18;						/* print working dir */
const CS_FTP_CWD=19;						/* change working dir */
const CS_FTP_DIR=20;						/* path */
const CS_FTP_PUT=21;						/* path */
const CS_FTP_GET=22;						/* path, offset */
const CS_FTP_RENAME=23;					
const CS_FTP_DELETE=24;
const CS_FTP_UNUSED7=25;
const CS_FTP_UNUSED6=26;
const CS_FTP_UNUSED5=27;
const CS_FTP_UNUSED4=28;
const CS_FTP_UNUSED3=29;
const CS_FTP_UNUSED2=30;
const CS_FTP_UNUSED1=31;

/* Preceeded by CS_FIO_FUNCTION */
const FIO_OPEN=0;						/* Open file (static filename) */
const FIO_CLOSE=1;						/* Close file */
const FIO_READ=2;						/* Read from file */
const FIO_READ_VAR=3;					/* Read from file, variable # of bytes */
const FIO_WRITE=4;						/* Write to file */
const FIO_WRITE_VAR=5;					/* Write to file, variable # of bytes */
const FIO_GET_LENGTH=6; 				/* Get length */
const FIO_EOF=7;						/* Set logic to TRUE if eof */
const FIO_GET_POS=8;					/* Get current file position */
const FIO_SEEK=9;						/* Seek within file */
const FIO_SEEK_VAR=10;					/* Seek within file, variable offset */
const FIO_LOCK=11;						/* Lock a region */
const FIO_LOCK_VAR=12;					/* Lock a region, variable length */
const FIO_UNLOCK=13; 					/* Unlock a region */
const FIO_UNLOCK_VAR=14; 				/* Unlock a region, variable length */
const FIO_SET_LENGTH=15; 				/* Change size */
const FIO_SET_LENGTH_VAR=16; 			/* Change size, variable length */
const FIO_PRINTF=17; 					/* Write formated string to file */
const FIO_SET_ETX=18;					/* Set end-of-text character */
const FIO_GET_TIME=19;					/* Gets the current date/time of file */
const FIO_SET_TIME=20;					/* Sets the current date/time of file */
const FIO_OPEN_VAR=21;					/* Open a file (dynamic filename) */
const FIO_READ_LINE=22;					/* Read a single line from file */
const FIO_FLUSH=23;						/* Flush buffered output to disk */
const FIO_UNUSED8=24;
const FIO_UNUSED7=25;
const FIO_UNUSED6=26;
const FIO_UNUSED5=27;
const FIO_UNUSED4=28;
const FIO_UNUSED3=29;
const FIO_UNUSED2=30;
const FIO_UNUSED1=31;
const REMOVE_FILE=32;					/* Remove a file */
const RENAME_FILE=33;					/* Rename a file */
const COPY_FILE=34;						/* Copy a file to another file */
const MOVE_FILE=35;						/* Move a file to another file */
const GET_FILE_ATTRIB=36;				/* Get file attributes */
const SET_FILE_ATTRIB=37;				/* Set file attributes */
const MAKE_DIR=38;						/* Make directory */
const CHANGE_DIR=39; 					/* Change current directory */
const REMOVE_DIR=40; 					/* Remove directory */
const OPEN_DIR=41;						/* Open a directory */
const READ_DIR=42;						/* Read a directory entry */
const REWIND_DIR=43; 					/* Rewind an open directory */
const CLOSE_DIR=44;						/* Close an open directory */

const CS_ONE_BYTE=CS_IF_TRUE;
const CS_TWO_BYTE=CS_CMDKEY;
const CS_THREE_BYTE=CS_GOTO;
const CS_ASCIIZ=CS_MENU;
const CS_MISC=CS_COMPARE_ARS;
const CS_FUNCTIONS=CS_MAIL_READ;
const CS_ELSEORENDIF=255;
const CS_NEXTCASE=254;

const CS_DIGIT=255;
const CS_EDIGIT=254;
const LOGIC_LESS=-1;
const LOGIC_EQUAL=0;
const LOGIC_GREATER=1;
const LOGIC_TRUE=LOGIC_EQUAL;
const LOGIC_FALSE=LOGIC_LESS;
