// This file defines some variables for various characters to be
// displayed to the user.
//
// Author: Eric Oulashin (AKA Nightfox)
// BBS: Digital Distortion
// BBS address: digitaldistortionbbs.com (or digdist.synchro.net)

"use strict";

// The source file src/xpdev/cp437defs.h in the Synchronet repository
// has CP437 character definitions for the C++ source


var CP437_WHITE_SMILING_FACE = "\x01";
var CP437_BLACK_SMILING_FACE = "\x02";
var CP437_BLACK_HEART_SUIT = "\x03";
var CP437_BLACK_DIAMOND_SUIT = "\x04";
var CP437_BLACK_CLUB_SUIT = "\x05";
var CP437_BLACK_SPADE_SUIT = "\x06";
var CP437_BULLET = "\x07";
var CP437_INVERSE_BULLET = "\x08";
var CP437_WHITE_CIRCLE = "\x09";
var CP437_INVERSE_WHITE_CIRCLE = "\x0A";
var CP437_MALE_SIGN = "\x0B";
var CP437_FEMALE_SIGN = "\x0C";
var CP437_EIGHTH_NOTE = "\x0D";
var CP437_BEAMED_EIGHTH_NOTES = "\x0E";
var CP437_WHITE_SUN_WITH_RAYS = "\x0F";
var CP437_BLACK_RIGHT_POINTING_POINTER = "\x10";
var CP437_BLACK_LEFT_POINTING_POINTER = "\x11";
var CP437_UP_DOWN_ARROW = "\x12";
var CP437_DOUBLE_EXCLAMATION_MARK = "\x13";
var CP437_PILCROW_SIGN = "\x14";	// Paragraph mark
var CP437_SECTION_SIGN = "\x15";
var CP437_BLACK_RECTANGLE = "\x16";
var CP437_UP_DOWN_ARROW_WITH_BASE = "\x17";
var CP437_UPWARDS_ARROW = "\x18";
var CP437_DOWNWARDS_ARROW = "\x19";
var CP437_RIGHTWARDS_ARROW = "\x1A";
var CP437_LEFTWARDS_ARROW = "\x1B";
var CP437_RIGHT_ANGLE = "\x1C";
var CP437_LEFT_RIGHT_ARROW = "\x1D";
var CP437_BLACK_UP_POINTING_TRIANGLE = "\x1E";
var CP437_BLACK_DOWN_POINTING_TRIANGLE = "\x1F";

// 0x20 - 0x7E are ASCII characters

var CP437_HOUSE = "\x7F";
var CP437_LATIN_CAPTIAL_LETTER_C_WITH_CEDILLA = "\x80";
var CP437_LATIN_SMALL_LETTER_U_WITH_DIAERESIS = "\x81";
var CP437_LATIN_SMALL_LETTER_E_WITH_ACUTE = "\x82";
var CP437_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX = "\x83";
var CP437_LATIN_SMALL_LETTER_A_WITH_DIAERESIS = "\x84";
var CP437_LATIN_SMALL_LETTER_A_WITH_GRAVE = "\x85";
var CP437_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE = "\x86";
var CP437_LATIN_SMALL_LETTER_C_WITH_CEDILLA = "\x87";
var CP437_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX = "\x88";
var CP437_LATIN_SMALL_LETTER_E_WITH_DIAERESIS = "\x89";
var CP437_LATIN_SMALL_LETTER_E_WITH_GRAVE = "\x8a";
var CP437_LATIN_SMALL_LETTER_I_WITH_DIAERESIS = "\x8b";
var CP437_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX = "\x8c";
var CP437_LATIN_SMALL_LETTER_I_WITH_GRAVE = "\x8d";
var CP437_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS = "\x8e";
var CP437_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE = "\x8f";
var CP437_LATIN_CAPITAL_LETTER_E_WITH_ACUTE = "\x90";
var CP437_LATIN_SMALL_LETTER_AE = "\x91";
var CP437_LATIN_CAPITAL_LETTER_AE = "\x92";
var CP437_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX = "\x93";
var CP437_LATIN_SMALL_LETTER_O_WITH_DIAERESIS = "\x94";
var CP437_LATIN_SMALL_LETTER_O_WITH_GRAVE = "\x95";
var CP437_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX = "\x96";
var CP437_LATIN_SMALL_LETTER_U_WITH_GRAVE = "\x97";
var CP437_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS = "\x98";
var CP437_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS = "\x99";
var CP437_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS = "\x9A";
var CP437_CENT_SIGN = "\x9B";
var CP437_POUND_SIGN = "\x9C";
var CP437_YEN_SIGN = "\x9E";
var CP437_PESETA_SIGN = "\x9E";
var CP437_LATIN_SMALL_LETTER_F_WITH_HOOK = "\x9F";
var CP437_LATIN_SMALL_LETTER_A_WITH_ACUTE = "\xA0";
var CP437_LATIN_SMALL_LETTER_I_WITH_ACUTE = "\xA1";
var CP437_LATIN_SMALL_LETTER_O_WITH_ACUTE = "\xA2";
var CP437_LATIN_SMALL_LETTER_U_WITH_ACUTE = "\xA3";
var CP437_LATIN_SMALL_LETTER_N_WITH_TILDE = "\xA4";
var CP437_LATIN_CAPITAL_LETTER_N_WITH_TILDE = "\xA5";
var CP437_FEMININE_ORDINAL_INDICATOR = "\xA6";
var CP437_MASCULINE_ORDINAL_INDICATOR = "\xA7";
var CP437_INVERTED_QUESTION_MARK = "\xA8";
var CP437_REVERSED_NOT_SIGN = "\xA9";
var CP437_NOT_SIGN = "\xAA";
var CP437_VULGAR_FRACTION_ONE_HALF = "\xAB";
var CP437_VULGAR_FRACTION_ONE_QUARTER = "\xAC";
var CP437_INVERTED_EXCLAMATION_MARK = "\xAD";
var CP437_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK = "\xAE";
var CP437_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK = "\xAF";

// Box-drawing/border characters: Single-line
var CP437_BOX_DRAWINGS_UPPER_LEFT_SINGLE = "\xDA";
var CP437_BOX_DRAWINGS_HORIZONTAL_SINGLE = "\xC4";
var CP437_BOX_DRAWINGS_UPPER_RIGHT_SINGLE = "\xBF";

var CP437_BOX_DRAWINGS_LIGHT_VERTICAL = "\xB3";

// TODO: CP437_BOX_DRAWINGS_LOWER_LEFT_SINGLE -> CP437_BOX_DRAWINGS_LIGHT_LOWER_LEFT
// TODO: CP437_BOX_DRAWINGS_LOWER_RIGHT_SINGLE -> CP437_BOX_DRAWINGS_LIGHT_LOWER_RIGHT
var CP437_BOX_DRAWINGS_LOWER_LEFT_SINGLE = "\xC0";
var CP437_BOX_DRAWINGS_LOWER_RIGHT_SINGLE = "\xD9";
var CP437_BOX_DRAWINGS_LIGHT_T = "\xC2";
var CP437_BOX_DRAWINGS_LIGHT_LEFT_T = "\xC3";
var CP437_BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT = "\xB4";
var CP437_BOX_DRAWINGS_LIGHT_BOTTOM_T = "\xC1";
var CP437_BOX_DRAWINGS_VERTICAL_AND_HORIZONTAL = "\xC5";
// Box-drawing/border characters: Double-line
var CP437_BOX_DRAWINGS_UPPER_LEFT_DOUBLE = "\xC9";
var CP437_BOX_DRAWINGS_HORIZONTAL_DOUBLE = "\xCD";
var CP437_BOX_DRAWINGS_UPPER_RIGHT_DOUBLE = "\xBB";
var CP437_BOX_DRAWINGS_DOUBLE_VERTICAL = "\xBA";
var CP437_BOX_DRAWINGS_LOWER_LEFT_DOUBLE = "\xC8";
var CP437_BOX_DRAWINGS_LOWER_RIGHT_DOUBLE = "\xBC";
var CP437_BOX_DRAWINGS_DOUBLE_T = "\xCB";
var CP437_BOX_DRAWINGS_LEFT_DOUBLE_T = "\xCC";
var CP437_BOX_DRAWINGS_RIGHT_DOUBLE_T = "\xB9";
var CP437_BOX_DRAWINGS_BOTTOM_DOUBLE_T = "\xCA";
var CP437_BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE = "\xB5";
var CP437_BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE = "\xC6";
var CP437_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE = '\xB6';
var CP437_BOX_DRAWINGS_DOUBLE_CROSS = "\xCE";
// Box-drawing/border characters: Vertical single-line with horizontal double-line
var CP437_BOX_DRAWINGS_UPPER_LEFT_VSINGLE_HDOUBLE = "\xD5";
var CP437_BOX_DRAWINGS_UPPER_RIGHT_VSINGLE_HDOUBLE = "\xB8";
var CP437_BOX_DRAWINGS_LOWER_LEFT_VSINGLE_HDOUBLE = "\xD4";
var CP437_BOX_DRAWINGS_LOWER_RIGHT_VSINGLE_HDOUBLE = "\xBE";
// Other special characters
var CP437_BULLET_OPERATOR = "\xF9";
var CP437_SQUARE_ROOT = "\xFB";
var CP437_CHECK_MARK = "\xFB"; // Duplicate
var CP437_LEFT_HALF_BLOCK = "\xDD";
var CP437_RIGHT_HALF_BLOCK = "\xDE";
var CP437_BLACK_SQUARE = "\xFE";
var CP437_HALFWIDTH_BLACK_SQUARE = "\xFE";	// Duplicate
var CP437_LIGHT_SHADE = "\xB0"; // Dimmest block
var CP437_MEDIUM_SHADE = "\xB1";
var CP437_DARK_SHADE = "\xB2";
var CP437_FULL_BLOCK = "\xDB"; // Brightest block
var CP437_LOWER_HALF_BLOCK = "\xDC";
var CP437_UPPER_HALF_BLOCK = "\xDF";
var CP437_MIDDLE_DOT = "\xFA";

var CP437_GREEK_SMALL_LETTER_ALPHA = "\xE0";
var CP437_GREEK_SMALL_LETTER_BETA = "\xE1";
var CP437_LATIN_SMALL_LETTER_SHARP_S = "\xE1";		// Duplicate
var CP437_GREEK_CAPITAL_LETTER_GAMMA = "\xE2";
var CP437_GREEK_SMALL_LETTER_PI = "\xE3";
var CP437_GREEK_CAPITAL_LETTER_SIGMA = "\xE4";
var CP437_GREEK_SMALL_LETTER_SIGMA = "\xE5";
var CP437_GREEK_SMALL_LETTER_MU = "\xE6";
var CP437_MICRO_SIGN = "\xE6";	// Duplicate
var CP437_GREEK_SMALL_LETTER_TAU = "\xE7";
var CP437_GREEK_CAPITAL_LETTER_PHI = "\xE8";
var CP437_GREEK_SMALL_LETTER_THETA = "\xE9";
var CP437_GREEK_CAPITAL_LETTER_OMEGA = "\xEA";
var CP437_GREEK_SMALL_LETTER_DELTA = "\xEB";
var CP437_INFINITY = "\xEC";
var CP437_GREEK_SMALL_LETTER_PHI = "\xED";
var CP437_GREEK_SMALL_LETTER_EPSILION = "\xEE";
var CP437_INTERSECTION = "\xEF";
var CP437_IDENTICAL_TO = "\xF0";
var CP437_TRIPLE_BAR = "\xF0";	// Duplicate
var CP437_PLUS_MINUS_SIGN = "\xF1";
var CP437_GREATER_THAN_OR_EQUAL_TO = "\xF2";
var CP437_LESS_THAN_OR_EQUAL_TO = "\xF3";
var CP437_TOP_HALF_INTEGRAL = "\xF4";
var CP437_BOTTOM_HALF_INTEGRAL = "\xF5";
var CP437_DIVISION_SIGN = "\xF6";
var CP437_ALMOST_EQUAL_TO = "\xF7";
var CP437_DEGREE_SIGN = "\xF8";

var CP437_SUPERSCRIPT_LATIN_SMALL_LETTER_N = "\xFC";
var CP437_SUPERSCRIPT_TWO = "\xFD";
var CP437_NO_BREAK_SPACE = "\xFF";
