// This test requires Synchronet v3.20c or later to pass

var test = {
	"50 ":		"19500101",
	"60.1":		"19600101",
	"69e1":		"19690101",
	"12 31 1969":	"19691231",
	"12.31.1969":	"19691231",
	"12.31.1969.1":	"19691231",
	"12-31-1969":	"19691231",
	"12*31*1969":	"19691231",
	"12@31#1969":	"19691231",
	"12%31^1969":	"19691231",
	"12&31$1969":	"19691231",
	"12/31/1969":	"19691231",
	"12/32/1969":	"19691231",
	"31/12/1969":	"19691231",
	"1969/12/31":	"19691231",
	"70":		"19700101",
	"1970":		"19700101",
	"19700101":	"19700101",
	"1/1/70":	"19700101",
	"01/01/70":	"19700101",
	"001/001/070":	"19700101",
	"01/01/1970":	"19700101",
	"1970/01":	"19700101",
	"01/1970":	"19700101",
	"1970/1":	"19700101",
	"1/1970":	"19700101",
	"00/00/00":	"20000101",
	"1":		"20010101",
	"10":		"20100101",
	"11/11/11":	"20111111", // Nigel Tufnel Day
	"12/13":	"20131201",
	"13/12":	"20131201",
	"19":		"20190101",
	// Ambiguous year "20" and higher is a moving target, so don't test
	"2038/12/31":	"20381231",
	"2106/12/31":	"21061231",
	"3000/01/01":	"30000101",
	"3000/12/31":	"30001231",
}

for (var i in test) {
	var u = new User;
	u.birthdate = i;
	if (u.birthdate != test[i])
		throw new Error(format("birthdate='%s' produced '%s' instead of expected: '%s'"
			,i, u.birthdate, test[i]));
}
