; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "Synchronet BBS Software"
#define MyAppVersion "3.21c"
#define MyAppPublisher "Rob Swindell"
#define MyAppURL "http://www.synchro.net/"
#define MyAppSupportURL "http://wiki.synchro.net/howto:support"
#define MyAppDownloadURL "http://www.synchro.net/download.html"
#define release "release"
#define source "c:\sbbs"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{2AC457EF-EDA4-4BDC-B6C0-D49ADB44ABF5}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
AppVerName={#MyAppName} v{#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppSupportURL}
AppUpdatesURL={#MyAppDownloadURL}
AppCopyright=Copyright 2026 {#MyAppPublisher}
VersionInfoVersion=3.21.2
AppMutex=sbbs_running,sbbsctrl_running
DefaultDirName={sd}\sbbs
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=yes
AllowNoIcons=yes
; OutputDir=.
OutputBaseFilename=upgrade_to_SBBS_v{#MyAppVersion}
Compression=lzma
SolidCompression=yes
MinVersion = 6.0
InfoBeforeFile=docs\upgrade.rtf
SourceDir={#source}
Uninstallable=no
DirExistsWarning=no
DisableDirPage=no

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Messages]
ButtonInstall=&Upgrade
WizardReady=Ready to Upgrade
SetupWindowTitle=Upgrade - %1
SetupLdrStartupMessage=This will upgrade %1. Do you wish to continue?
InfoBeforeClickLabel=When you are ready to continue with the upgrade, click Next.
SelectDirDesc=Where is [name] installed?
SelectDirLabel3=Setup will upgrade [name] in the following folder.
SelectTasksLabel2=Select the additional tasks you would like Setup to perform while upgrading [name], then click Next.
ReadyLabel1=Setup is now ready to begin upgrading [name] on your computer.
ReadyLabel2a=Click Upgrade to continue with the upgrade, or click Back if you want to review or change any settings.
ReadyLabel2b=Click Upgrade to continue with the upgrade.
WizardPreparing=Preparing to Upgrade
PreparingDesc=Setup is preparing to upgrade [name] on your computer.
WizardInstalling=Upgrading
InstallingLabel=Please wait while Setup upgrades [name] on your computer.
FinishedLabelNoIcons=Setup has finished upgrading [name] on your computer.

[Tasks]
Name: "upgrade_xtrn"; Description: "Programs/scripts (e.g. door games) in the xtrn directory"; GroupDescription: "Upgrade Externals";
Name: "upgrade_webv4"; Description: "echicken's Synchronet Web UI (ecWebv4) in the webv4 directory"; GroupDescription: "Upgrade Web UI";

[Files]
Source: "src\sbbs3\ctrl\sbbsctrl.exe";                        DestDir: "{app}\exec";  Flags: ignoreversion
Source: "src\sbbs3\chat\chat.exe";                            DestDir: "{app}\exec";  Flags: ignoreversion
Source: "src\sbbs3\useredit\useredit.exe";                    DestDir: "{app}\exec";  Flags: ignoreversion
Source: "src\sbbs3\msvc.win32.exe.{#release}\*.exe";          DestDir: "{app}\exec";  Flags: ignoreversion; Excludes: "textgen.exe"
Source: "src\sbbs3\msvc.win32.dll.{#release}\*.dll";          DestDir: "{app}\exec";  Flags: ignoreversion
Source: "src\sbbs3\msvc.win32.dll.{#release}\sbbsexec.dll";   DestDir: "{sys}";
Source: "src\sbbs3\scfg\msvc.win32.exe.{#release}\scfg.exe";  DestDir: "{app}\exec";  Flags: ignoreversion
Source: "3rdp\win32.release\nspr\bin\nspr4.dll";       	      DestDir: "{app}\exec";  Flags: ignoreversion
Source: "3rdp\win32.release\mozjs\bin\mozjs185-1.0.dll";      DestDir: "{app}\exec";  Flags: ignoreversion
Source: "3rdp\win32.release\cryptlib\bin\cl32.dll";           DestDir: "{app}\exec";  Flags: ignoreversion
Source: "3rdp\win32.release\libarchive\bin\archive.dll";      DestDir: "{app}\exec";  Flags: ignoreversion
Source: "3rdp\win32.release\zlib\bin\zlib1.dll";              DestDir: "{app}\exec";  Flags: ignoreversion
Source: "3rdp\win32.release\mosquitto\bin\mosquitto.dll";     DestDir: "{app}\exec";  Flags: ignoreversion
Source: "src\sexpots\{#release}\sexpots.exe";                 DestDir: "{app}\exec";  Flags: ignoreversion
Source: "s:\sbbs\exec\user.com";                              DestDir: "{app}\exec";  Flags: ignoreversion
Source: "s:\sbbs\exec\mlabels.exe";                           DestDir: "{app}\exec";  Flags: ignoreversion
Source: "s:\sbbs\exec\svdmansi.com";                          DestDir: "{app}\exec";  Flags: ignoreversion
Source: "s:\sbbs\exec\dosxtrn.exe";                           DestDir: "{app}\exec";  Flags: ignoreversion
Source: "ctrl\text.dat";                                      DestDir: "{app}\ctrl";  Flags: ignoreversion
Source: "exec\*";   DestDir: "{app}\exec";  Flags: ignoreversion recursesubdirs createallsubdirs; Excludes: "baja.js,menu.js,sbbsedit.js,jsdocs.js,testbuild.js,load\menulib.js"
Source: "text\*";   DestDir: "{app}\text";  Flags: ignoreversion recursesubdirs createallsubdirs; Excludes: "*.0??.*,.gitignore,random*.msg"
Source: "xtrn\*";   DestDir: "{app}\xtrn";  Flags: ignoreversion recursesubdirs createallsubdirs; Excludes: "*.obj,*.tds,*.o,*.d,smm,.gitignore,gcc.*,bcc.*"; Tasks: upgrade_xtrn
Source: "docs\*";   DestDir: "{app}\docs";  Flags: ignoreversion recursesubdirs createallsubdirs
Source: "webv4\*";                                            DestDir: "{app}\webv4"; Flags: ignoreversion recursesubdirs createallsubdirs; Tasks: upgrade_webv4
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[INI]
Filename: "{app}\ctrl\sbbs.ini"; Section: "Web";      Key: "RootDirectory"; String: "../webv4/root"; Tasks: upgrade_webv4

[Run]
; First time jsexec is run might not load config (when upgrading from v3.19 and earlier)
Filename: "{app}\exec\jsexec"; Parameters: "-U -! update.js"
Filename: "{app}\exec\jsexec"; Parameters: "-p update.js"
