#ifndef _HTMLANSI_H
#define _HTMLANSI_H

/* Note: These are defined in ANSI order (i.e. black, red, green, yellow, ...) */
/* and *not* the IBM CGA order (i.e. black, blue, green, cyan, ...) */
/* Maybe this was not original intention? */

/* Note: dark yellow (brown) follows the IBM CGA convention of lowering the */
/* green component to yield a more pleasing brown-tone. */
/* See http://en.wikipedia.org/wiki/Color_Graphics_Adapter for more details */

/* Note: The RGB values here were taken from Grymmjack's Windows NT ANSI */
/* color fix pack. According to him, the "correct" range is 0-252 (not 255) */
/* with half and quarter values of 168 and 84, respectively */

const char *htmlansi[256] =
{
	"color: black; background-color: black;",       /* black */
	"color: #a80000; background-color: black;",     /* dark red */
	"color: #00a800; background-color: black;",     /* dark green */
	"color: #a85400; background-color: black;",     /* brown (dark yellow) */
	"color: #0000a8; background-color: black;",     /* dark blue */
	"color: #a800a8; background-color: black;",     /* magenta */
	"color: #00a8a8; background-color: black;",     /* cyan */
	"color: #a8a8a8; background-color: black;",     /* white */
	"color: #545454; background-color: black;",     /* bright black (grey) */
	"color: #fc5454; background-color: black;",     /* bright red */
	"color: #54fc54; background-color: black;",     /* bright green */
	"color: #fcfc54; background-color: black;",     /* bright yellow */
	"color: #5454fc; background-color: black;",     /* bright blue */
	"color: #fc54fc; background-color: black;",     /* bright magenta */
	"color: #54fcfc; background-color: black;",     /* bright cyan */
	"color: white; background-color: black;",       /* bright white */
	/* Background: red */
	"color: black; background-color: #a80000;",
	"color: #a80000; background-color: #a80000;",
	"color: #00a800; background-color: #a80000;",
	"color: #a85400; background-color: #a80000;",
	"color: #0000a8; background-color: #a80000;",
	"color: #a800a8; background-color: #a80000;",
	"color: #00a8a8; background-color: #a80000;",
	"color: #a8a8a8; background-color: #a80000;",
	"color: #545454; background-color: #a80000;",
	"color: #fc5454; background-color: #a80000;",
	"color: #54fc54; background-color: #a80000;",
	"color: #fcfc54; background-color: #a80000;",
	"color: #5454fc; background-color: #a80000;",
	"color: #fc54fc; background-color: #a80000;",
	"color: #54fcfc; background-color: #a80000;",
	"color: white; background-color: #a80000;",
	/* Background: green */
	"color: black; background-color: #00a800;",
	"color: #a80000; background-color: #00a800;",
	"color: #00a800; background-color: #00a800;",
	"color: #a85400; background-color: #00a800;",
	"color: #0000a8; background-color: #00a800;",
	"color: #a800a8; background-color: #00a800;",
	"color: #00a8a8; background-color: #00a800;",
	"color: #a8a8a8; background-color: #00a800;",
	"color: #545454; background-color: #00a800;",
	"color: #fc5454; background-color: #00a800;",
	"color: #54fc54; background-color: #00a800;",
	"color: #fcfc54; background-color: #00a800;",
	"color: #5454fc; background-color: #00a800;",
	"color: #fc54fc; background-color: #00a800;",
	"color: #54fcfc; background-color: #00a800;",
	"color: white; background-color: #00a800;",
	/* Background: brown (dark yellow) */
	"color: black; background-color: #a85400;",
	"color: #a80000; background-color: #a85400;",
	"color: #00a800; background-color: #a85400;",
	"color: #a85400; background-color: #a85400;",
	"color: #0000a8; background-color: #a85400;",
	"color: #a800a8; background-color: #a85400;",
	"color: #00a8a8; background-color: #a85400;",
	"color: #a8a8a8; background-color: #a85400;",
	"color: #545454; background-color: #a85400;",
	"color: #fc5454; background-color: #a85400;",
	"color: #54fc54; background-color: #a85400;",
	"color: #fcfc54; background-color: #a85400;",
	"color: #5454fc; background-color: #a85400;",
	"color: #fc54fc; background-color: #a85400;",
	"color: #54fcfc; background-color: #a85400;",
	"color: white; background-color: #a85400;",
	/* Background: blue */
	"color: black; background-color: #0000a8;",
	"color: #a80000; background-color: #0000a8;",
	"color: #00a800; background-color: #0000a8;",
	"color: #a85400; background-color: #0000a8;",
	"color: #0000a8; background-color: #0000a8;",
	"color: #a800a8; background-color: #0000a8;",
	"color: #00a8a8; background-color: #0000a8;",
	"color: #a8a8a8; background-color: #0000a8;",
	"color: #545454; background-color: #0000a8;",
	"color: #fc5454; background-color: #0000a8;",
	"color: #54fc54; background-color: #0000a8;",
	"color: #fcfc54; background-color: #0000a8;",
	"color: #5454fc; background-color: #0000a8;",
	"color: #fc54fc; background-color: #0000a8;",
	"color: #54fcfc; background-color: #0000a8;",
	"color: white; background-color: #0000a8;",
	/* Background: magenta */
	"color: black; background-color: #a800a8;",
	"color: #a80000; background-color: #a800a8;",
	"color: #00a800; background-color: #a800a8;",
	"color: #a85400; background-color: #a800a8;",
	"color: #0000a8; background-color: #a800a8;",
	"color: #a800a8; background-color: #a800a8;",
	"color: #00a8a8; background-color: #a800a8;",
	"color: #a8a8a8; background-color: #a800a8;",
	"color: #545454; background-color: #a800a8;",
	"color: #fc5454; background-color: #a800a8;",
	"color: #54fc54; background-color: #a800a8;",
	"color: #fcfc54; background-color: #a800a8;",
	"color: #5454fc; background-color: #a800a8;",
	"color: #fc54fc; background-color: #a800a8;",
	"color: #54fcfc; background-color: #a800a8;",
	"color: white; background-color: #a800a8;",
	/* Background: cyan */
	"color: black; background-color: #00a8a8;",
	"color: #a80000; background-color: #00a8a8;",
	"color: #00a800; background-color: #00a8a8;",
	"color: #a85400; background-color: #00a8a8;",
	"color: #0000a8; background-color: #00a8a8;",
	"color: #a800a8; background-color: #00a8a8;",
	"color: #00a8a8; background-color: #00a8a8;",
	"color: #a8a8a8; background-color: #00a8a8;",
	"color: #545454; background-color: #00a8a8;",
	"color: #fc5454; background-color: #00a8a8;",
	"color: #54fc54; background-color: #00a8a8;",
	"color: #fcfc54; background-color: #00a8a8;",
	"color: #5454fc; background-color: #00a8a8;",
	"color: #fc54fc; background-color: #00a8a8;",
	"color: #54fcfc; background-color: #00a8a8;",
	"color: white; background-color: #00a8a8;",
	/* Background: white */
	"color: black; background-color: #a8a8a8;",
	"color: #a80000; background-color: #a8a8a8;",
	"color: #00a800; background-color: #a8a8a8;",
	"color: #a85400; background-color: #a8a8a8;",
	"color: #0000a8; background-color: #a8a8a8;",
	"color: #a800a8; background-color: #a8a8a8;",
	"color: #00a8a8; background-color: #a8a8a8;",
	"color: #a8a8a8; background-color: #a8a8a8;",
	"color: #545454; background-color: #a8a8a8;",
	"color: #fc5454; background-color: #a8a8a8;",
	"color: #54fc54; background-color: #a8a8a8;",
	"color: #fcfc54; background-color: #a8a8a8;",
	"color: #5454fc; background-color: #a8a8a8;",
	"color: #fc54fc; background-color: #a8a8a8;",
	"color: #54fcfc; background-color: #a8a8a8;",
	"color: white; background-color: #a8a8a8;",
	"text-decoration: blink; color: black; background-color: black;",
	"text-decoration: blink; color: #a80000; background-color: black;",
	"text-decoration: blink; color: #00a800; background-color: black;",
	"text-decoration: blink; color: #a85400; background-color: black;",
	"text-decoration: blink; color: #0000a8; background-color: black;",
	"text-decoration: blink; color: #a800a8; background-color: black;",
	"text-decoration: blink; color: #00a8a8; background-color: black;",
	"text-decoration: blink; color: #a8a8a8; background-color: black;",
	"text-decoration: blink; color: #545454; background-color: black;",
	"text-decoration: blink; color: #fc5454; background-color: black;",
	"text-decoration: blink; color: #54fc54; background-color: black;",
	"text-decoration: blink; color: #fcfc54; background-color: black;",
	"text-decoration: blink; color: #5454fc; background-color: black;",
	"text-decoration: blink; color: #fc54fc; background-color: black;",
	"text-decoration: blink; color: #54fcfc; background-color: black;",
	"text-decoration: blink; color: white; background-color: black;",
	"text-decoration: blink; color: black; background-color: #a80000;",
	"text-decoration: blink; color: #a80000; background-color: #a80000;",
	"text-decoration: blink; color: #00a800; background-color: #a80000;",
	"text-decoration: blink; color: #a85400; background-color: #a80000;",
	"text-decoration: blink; color: #0000a8; background-color: #a80000;",
	"text-decoration: blink; color: #a800a8; background-color: #a80000;",
	"text-decoration: blink; color: #00a8a8; background-color: #a80000;",
	"text-decoration: blink; color: #a8a8a8; background-color: #a80000;",
	"text-decoration: blink; color: #545454; background-color: #a80000;",
	"text-decoration: blink; color: #fc5454; background-color: #a80000;",
	"text-decoration: blink; color: #54fc54; background-color: #a80000;",
	"text-decoration: blink; color: #fcfc54; background-color: #a80000;",
	"text-decoration: blink; color: #5454fc; background-color: #a80000;",
	"text-decoration: blink; color: #fc54fc; background-color: #a80000;",
	"text-decoration: blink; color: #54fcfc; background-color: #a80000;",
	"text-decoration: blink; color: white; background-color: #a80000;",
	"text-decoration: blink; color: black; background-color: #00a800;",
	"text-decoration: blink; color: #a80000; background-color: #00a800;",
	"text-decoration: blink; color: #00a800; background-color: #00a800;",
	"text-decoration: blink; color: #a85400; background-color: #00a800;",
	"text-decoration: blink; color: #0000a8; background-color: #00a800;",
	"text-decoration: blink; color: #a800a8; background-color: #00a800;",
	"text-decoration: blink; color: #00a8a8; background-color: #00a800;",
	"text-decoration: blink; color: #a8a8a8; background-color: #00a800;",
	"text-decoration: blink; color: #545454; background-color: #00a800;",
	"text-decoration: blink; color: #fc5454; background-color: #00a800;",
	"text-decoration: blink; color: #54fc54; background-color: #00a800;",
	"text-decoration: blink; color: #fcfc54; background-color: #00a800;",
	"text-decoration: blink; color: #5454fc; background-color: #00a800;",
	"text-decoration: blink; color: #fc54fc; background-color: #00a800;",
	"text-decoration: blink; color: #54fcfc; background-color: #00a800;",
	"text-decoration: blink; color: white; background-color: #00a800;",
	"text-decoration: blink; color: black; background-color: #a85400;",
	"text-decoration: blink; color: #a80000; background-color: #a85400;",
	"text-decoration: blink; color: #00a800; background-color: #a85400;",
	"text-decoration: blink; color: #a85400; background-color: #a85400;",
	"text-decoration: blink; color: #0000a8; background-color: #a85400;",
	"text-decoration: blink; color: #a800a8; background-color: #a85400;",
	"text-decoration: blink; color: #00a8a8; background-color: #a85400;",
	"text-decoration: blink; color: #a8a8a8; background-color: #a85400;",
	"text-decoration: blink; color: #545454; background-color: #a85400;",
	"text-decoration: blink; color: #fc5454; background-color: #a85400;",
	"text-decoration: blink; color: #54fc54; background-color: #a85400;",
	"text-decoration: blink; color: #fcfc54; background-color: #a85400;",
	"text-decoration: blink; color: #5454fc; background-color: #a85400;",
	"text-decoration: blink; color: #fc54fc; background-color: #a85400;",
	"text-decoration: blink; color: #54fcfc; background-color: #a85400;",
	"text-decoration: blink; color: white; background-color: #a85400;",
	"text-decoration: blink; color: black; background-color: #0000a8;",
	"text-decoration: blink; color: #a80000; background-color: #0000a8;",
	"text-decoration: blink; color: #00a800; background-color: #0000a8;",
	"text-decoration: blink; color: #a85400; background-color: #0000a8;",
	"text-decoration: blink; color: #0000a8; background-color: #0000a8;",
	"text-decoration: blink; color: #a800a8; background-color: #0000a8;",
	"text-decoration: blink; color: #00a8a8; background-color: #0000a8;",
	"text-decoration: blink; color: #a8a8a8; background-color: #0000a8;",
	"text-decoration: blink; color: #545454; background-color: #0000a8;",
	"text-decoration: blink; color: #fc5454; background-color: #0000a8;",
	"text-decoration: blink; color: #54fc54; background-color: #0000a8;",
	"text-decoration: blink; color: #fcfc54; background-color: #0000a8;",
	"text-decoration: blink; color: #5454fc; background-color: #0000a8;",
	"text-decoration: blink; color: #fc54fc; background-color: #0000a8;",
	"text-decoration: blink; color: #54fcfc; background-color: #0000a8;",
	"text-decoration: blink; color: white; background-color: #0000a8;",
	"text-decoration: blink; color: black; background-color: #a800a8;",
	"text-decoration: blink; color: #a80000; background-color: #a800a8;",
	"text-decoration: blink; color: #00a800; background-color: #a800a8;",
	"text-decoration: blink; color: #a85400; background-color: #a800a8;",
	"text-decoration: blink; color: #0000a8; background-color: #a800a8;",
	"text-decoration: blink; color: #a800a8; background-color: #a800a8;",
	"text-decoration: blink; color: #00a8a8; background-color: #a800a8;",
	"text-decoration: blink; color: #a8a8a8; background-color: #a800a8;",
	"text-decoration: blink; color: #545454; background-color: #a800a8;",
	"text-decoration: blink; color: #fc5454; background-color: #a800a8;",
	"text-decoration: blink; color: #54fc54; background-color: #a800a8;",
	"text-decoration: blink; color: #fcfc54; background-color: #a800a8;",
	"text-decoration: blink; color: #5454fc; background-color: #a800a8;",
	"text-decoration: blink; color: #fc54fc; background-color: #a800a8;",
	"text-decoration: blink; color: #54fcfc; background-color: #a800a8;",
	"text-decoration: blink; color: white; background-color: #a800a8;",
	"text-decoration: blink; color: black; background-color: #00a8a8;",
	"text-decoration: blink; color: #a80000; background-color: #00a8a8;",
	"text-decoration: blink; color: #00a800; background-color: #00a8a8;",
	"text-decoration: blink; color: #a85400; background-color: #00a8a8;",
	"text-decoration: blink; color: #0000a8; background-color: #00a8a8;",
	"text-decoration: blink; color: #a800a8; background-color: #00a8a8;",
	"text-decoration: blink; color: #00a8a8; background-color: #00a8a8;",
	"text-decoration: blink; color: #a8a8a8; background-color: #00a8a8;",
	"text-decoration: blink; color: #545454; background-color: #00a8a8;",
	"text-decoration: blink; color: #fc5454; background-color: #00a8a8;",
	"text-decoration: blink; color: #54fc54; background-color: #00a8a8;",
	"text-decoration: blink; color: #fcfc54; background-color: #00a8a8;",
	"text-decoration: blink; color: #5454fc; background-color: #00a8a8;",
	"text-decoration: blink; color: #fc54fc; background-color: #00a8a8;",
	"text-decoration: blink; color: #54fcfc; background-color: #00a8a8;",
	"text-decoration: blink; color: white; background-color: #00a8a8;",
	"text-decoration: blink; color: black; background-color: #a8a8a8;",
	"text-decoration: blink; color: #a80000; background-color: #a8a8a8;",
	"text-decoration: blink; color: #00a800; background-color: #a8a8a8;",
	"text-decoration: blink; color: #a85400; background-color: #a8a8a8;",
	"text-decoration: blink; color: #0000a8; background-color: #a8a8a8;",
	"text-decoration: blink; color: #a800a8; background-color: #a8a8a8;",
	"text-decoration: blink; color: #00a8a8; background-color: #a8a8a8;",
	"text-decoration: blink; color: #a8a8a8; background-color: #a8a8a8;",
	"text-decoration: blink; color: #545454; background-color: #a8a8a8;",
	"text-decoration: blink; color: #fc5454; background-color: #a8a8a8;",
	"text-decoration: blink; color: #54fc54; background-color: #a8a8a8;",
	"text-decoration: blink; color: #fcfc54; background-color: #a8a8a8;",
	"text-decoration: blink; color: #5454fc; background-color: #a8a8a8;",
	"text-decoration: blink; color: #fc54fc; background-color: #a8a8a8;",
	"text-decoration: blink; color: #54fcfc; background-color: #a8a8a8;",
	"text-decoration: blink; color: white; background-color: #a8a8a8;",
};

#define HTML_COLOR_PREFIX       "</span><span style=\""
#define HTML_COLOR_SUFFIX       "\">"

#define MAX_COLOR_STRING 100

#endif /* Don't add anything after this #endif statement */
