#include <stdio.h>
#include <string.h>

#include <ciolib.h>
#include <gen_defs.h>

#include "xpendian.h"

#include "key.h"
#include "syncdraw.h"
#include "miscfunctions.h"
#include "sauce.h"

SauceRecord     SauceDescr;

const char   SauceAnsi[4096] = {
	32, 7, 32, 7, 32, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 223, 8, 32,
	8, 223, 8, 32, 8, 223, 8, 32, 8, 32, 8, 32, 8, 223, 8, 223, 8, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 223,
	8, 32, 8, 32, 8, 32, 8, 223, 8, 32, 8, 223, 8, 32, 8, 223, 8, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 32, 8, 32, 8, 32, 8, 32, 8, 32, 8, 32, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 223, 3, 32, 3, 219, 8, 219, 8, 32, 8, 32, 8, 219, 8, 219, 8, 32, 8, 32,
	56, 32, 56, 176, 50, 32, 50, 223, 3, 32, 51, 32, 51, 0, 7, 32, 51, 176, 50, 32,
	50, 32, 50, 223, 3, 32, 51, 32, 51, 0, 7, 32, 51, 32, 51, 32, 51, 32, 51, 0,
	7, 32, 51, 32, 51, 0, 7, 32, 51, 176, 50, 32, 50, 32, 50, 223, 3, 32, 51, 32,
	51, 0, 7, 32, 51, 176, 50, 32, 50, 32, 50, 223, 3, 32, 51, 32, 51, 0, 7, 219,
	8, 32, 8, 32, 8, 219, 8, 219, 8, 32, 8, 223, 3, 32, 3, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 176, 50, 0, 7, 219, 8, 219, 8, 32, 8, 32, 8, 219, 8, 219, 8, 32, 8, 176,
	50, 176, 50, 176, 50, 176, 50, 0, 7, 0, 7, 0, 7, 0, 7, 176, 50, 176, 50, 176,
	50, 176, 50, 0, 7, 176, 50, 176, 50, 0, 7, 176, 50, 176, 50, 176, 50, 176, 50, 0,
	7, 176, 50, 176, 50, 0, 7, 176, 50, 176, 50, 176, 50, 176, 50, 0, 7, 0, 7, 0,
	7, 0, 7, 176, 50, 176, 50, 176, 50, 176, 50, 0, 7, 0, 7, 0, 7, 220, 8, 219,
	8, 32, 8, 32, 8, 219, 8, 219, 8, 32, 8, 176, 50, 0, 7, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 220, 8, 220, 8, 219, 8, 219, 8, 32,
	8, 177, 50, 0, 7, 219, 8, 219, 8, 220, 8, 220, 8, 219, 8, 219, 8, 32, 8, 223,
	3, 223, 3, 223, 3, 223, 3, 223, 3, 177, 50, 177, 50, 222, 8, 177, 50, 177, 50, 177,
	50, 177, 50, 223, 3, 177, 50, 177, 50, 222, 8, 177, 50, 177, 50, 177, 50, 177, 50, 222,
	8, 177, 50, 177, 50, 222, 8, 177, 50, 177, 50, 177, 50, 177, 50, 0, 7, 0, 7, 0,
	7, 222, 8, 177, 50, 177, 50, 177, 50, 177, 50, 223, 3, 32, 3, 32, 3, 219, 8, 219,
	8, 220, 8, 220, 8, 219, 8, 219, 8, 32, 8, 177, 50, 0, 7, 219, 8, 219, 8, 220,
	8, 220, 8, 220, 8, 220, 8, 220, 8, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 32,
	8, 32, 8, 223, 8, 32, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 32,
	8, 178, 50, 0, 7, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 32, 8, 222, 8, 219,
	50, 178, 50, 219, 50, 178, 50, 0, 7, 219, 50, 178, 50, 222, 8, 219, 50, 178, 50, 219,
	50, 178, 50, 222, 8, 219, 50, 178, 50, 222, 8, 178, 50, 219, 50, 178, 50, 219, 50, 222,
	8, 178, 50, 219, 50, 222, 8, 178, 50, 219, 50, 219, 50, 178, 50, 0, 7, 0, 7, 0,
	7, 222, 8, 219, 50, 178, 50, 219, 50, 178, 50, 0, 7, 0, 7, 0, 7, 223, 8, 223,
	8, 223, 8, 223, 8, 223, 8, 223, 8, 32, 8, 178, 50, 0, 7, 223, 8, 223, 8, 223,
	8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 32, 8, 223, 8, 0, 8, 32,
	8, 223, 8, 32, 8, 32, 8, 223, 2, 32, 2, 223, 2, 223, 2, 223, 2, 223, 2, 223,
	2, 219, 50, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 222, 8, 219,
	50, 219, 50, 219, 50, 219, 50, 219, 50, 219, 50, 219, 50, 222, 8, 219, 50, 219, 50, 219,
	50, 219, 50, 222, 8, 219, 50, 219, 50, 222, 8, 219, 50, 219, 50, 219, 50, 219, 50, 220,
	2, 219, 50, 219, 50, 222, 8, 219, 50, 219, 50, 219, 50, 219, 50, 220, 2, 219, 50, 219,
	50, 222, 8, 219, 50, 219, 50, 219, 50, 219, 50, 220, 2, 219, 50, 219, 50, 0, 7, 223,
	2, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 219, 50, 223, 2, 223, 2, 223, 2, 223,
	2, 223, 2, 223, 2, 223, 2, 223, 2, 32, 2, 223, 2, 32, 2, 32, 2, 223, 8, 32,
	8, 223, 8, 32, 8, 223, 8, 223, 8, 223, 8, 219, 8, 219, 8, 219, 8, 219, 8, 32,
	8, 178, 50, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32,
	15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32,
	15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32,
	15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32,
	15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32,
	15, 32, 15, 32, 15, 32, 15, 32, 15, 0, 7, 178, 50, 0, 7, 219, 8, 219, 8, 219,
	8, 219, 8, 219, 8, 219, 8, 219, 8, 223, 8, 223, 8, 223, 8, 32, 8, 223, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 178, 50, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 178, 50, 0, 7, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 177, 50, 0, 7, 0, 7, 32, 15, 83, 15, 65, 7, 86, 8, 69, 8, 32, 8, 83,
	15, 65, 7, 85, 8, 67, 8, 69, 8, 32, 8, 105, 15, 78, 7, 70, 8, 79, 8, 82,
	8, 77, 8, 65, 8, 84, 8, 105, 15, 79, 8, 78, 8, 58, 8, 32, 8, 91, 8, 32,
	15, 93, 8, 32, 8, 89, 15, 69, 7, 80, 8, 32, 8, 32, 8, 91, 8, 32, 15, 93,
	8, 32, 8, 78, 15, 79, 7, 80, 8, 69, 8, 0, 7, 0, 7, 0, 7, 32, 8, 32,
	8, 32, 8, 32, 8, 0, 7, 0, 7, 0, 7, 177, 50, 0, 7, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 177, 50, 0, 7, 0, 7, 0, 7, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32,
	15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 32, 15, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 177, 50, 0, 7, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 177, 50, 0, 7, 0, 7, 32, 7, 65, 15, 78, 7, 83, 8, 105, 8, 45, 8, 84,
	15, 105, 7, 84, 8, 76, 8, 69, 8, 32, 8, 0, 7, 91, 8, 250, 7, 250, 7, 250,
	7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250,
	7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250,
	7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250,
	7, 250, 7, 250, 7, 93, 8, 32, 7, 0, 7, 177, 50, 0, 7, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 176, 50, 0, 7, 0, 7, 32, 7, 65, 15, 82, 7, 84, 8, 105, 8, 83, 8, 84,
	8, 45, 8, 78, 15, 65, 7, 77, 8, 69, 8, 32, 8, 91, 8, 250, 7, 250, 7, 250,
	7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250,
	7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 93, 8, 32, 7, 32,
	7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 0,
	7, 0, 7, 32, 8, 0, 7, 32, 7, 0, 7, 176, 50, 0, 7, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 32, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 176, 50, 0, 7, 0, 7, 32, 7, 71, 15, 82, 7, 79, 8, 85, 8, 80, 8, 32,
	8, 32, 8, 32, 8, 32, 8, 32, 8, 32, 8, 32, 8, 91, 8, 250, 7, 250, 7, 250,
	7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250,
	7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 250, 7, 93, 8, 32, 7, 32,
	7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32,
	8, 32, 8, 32, 8, 0, 7, 32, 7, 0, 7, 176, 50, 0, 7, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 32, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 32, 56, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 32,
	7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32,
	7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32,
	7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32, 7, 32,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 32, 56, 0, 7, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 220, 8, 220, 8, 219, 8, 219, 8, 32,
	8, 32, 56, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 32, 56, 0, 7, 219, 8, 219, 8, 220,
	8, 220, 8, 220, 8, 220, 8, 220, 8, 220, 8, 0, 7, 0, 7, 0, 7, 0, 8, 32,
	8, 223, 8, 32, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 32,
	8, 32, 56, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 176, 50, 32, 50, 176, 50, 32, 50, 0, 7, 0, 7, 0, 7, 32, 50, 176,
	50, 32, 50, 32, 50, 223, 3, 32, 51, 32, 51, 0, 7, 0, 7, 0, 7, 32, 51, 32,
	51, 176, 50, 32, 50, 223, 3, 32, 51, 32, 51, 0, 7, 0, 7, 0, 7, 176, 50, 32,
	50, 32, 50, 32, 50, 223, 3, 32, 51, 32, 51, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 32, 51, 0, 7, 223, 8, 223, 8, 223,
	8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 32, 8, 223, 8, 223,
	8, 32, 8, 223, 3, 32, 3, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 223,
	3, 32, 51, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 223,
	3, 32, 3, 176, 50, 176, 50, 176, 50, 176, 50, 0, 7, 223, 3, 32, 3, 176, 50, 176,
	50, 176, 50, 176, 50, 0, 7, 176, 50, 176, 50, 0, 7, 223, 3, 32, 3, 176, 50, 176,
	50, 176, 50, 176, 50, 0, 7, 0, 7, 0, 7, 0, 7, 223, 3, 32, 3, 176, 50, 176,
	50, 176, 50, 176, 50, 0, 7, 176, 50, 176, 50, 0, 7, 223, 3, 223, 3, 223, 3, 223,
	3, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 32, 51, 223, 3, 223, 3, 223, 3, 223,
	3, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 223, 3, 32, 3, 223, 3, 0, 8, 32,
	3, 223, 8, 32, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 219, 8, 219, 8, 32,
	8, 177, 50, 0, 7, 219, 8, 223, 8, 32, 8, 223, 8, 32, 8, 223, 8, 223, 8, 221,
	8, 222, 8, 177, 50, 177, 50, 177, 50, 177, 50, 0, 7, 0, 7, 222, 8, 177, 50, 177,
	50, 177, 50, 177, 50, 222, 8, 177, 50, 177, 50, 0, 7, 0, 7, 222, 8, 177, 50, 177,
	50, 177, 50, 177, 50, 223, 3, 32, 3, 32, 3, 32, 3, 32, 3, 222, 8, 177, 50, 177,
	50, 177, 50, 177, 50, 222, 8, 177, 50, 177, 50, 0, 7, 219, 8, 223, 8, 223, 8, 32,
	8, 223, 8, 32, 8, 223, 8, 219, 8, 32, 8, 177, 50, 0, 7, 219, 8, 223, 8, 223,
	8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 223, 8, 32, 8, 223, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 223, 8, 32, 8, 223, 8, 223, 8, 223, 8, 32,
	8, 178, 50, 0, 7, 223, 8, 223, 8, 223, 8, 32, 8, 223, 8, 32, 8, 223, 8, 32,
	8, 222, 8, 219, 50, 178, 50, 219, 50, 178, 50, 0, 7, 0, 7, 222, 8, 178, 50, 219,
	50, 178, 50, 178, 50, 222, 8, 178, 50, 178, 50, 0, 7, 0, 7, 222, 8, 219, 50, 178,
	50, 219, 50, 178, 50, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 222, 8, 178, 50, 219,
	50, 178, 50, 219, 50, 222, 8, 219, 50, 178, 50, 0, 7, 223, 8, 223, 8, 32, 8, 223,
	8, 223, 8, 32, 8, 223, 8, 223, 8, 32, 8, 178, 50, 0, 7, 223, 8, 223, 8, 32,
	8, 223, 8, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 223, 2, 223, 2, 223,
	2, 219, 50, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 223,
	2, 222, 8, 219, 50, 219, 50, 219, 50, 219, 50, 0, 7, 223, 2, 222, 8, 219, 50, 219,
	50, 219, 50, 219, 50, 222, 8, 219, 50, 219, 50, 0, 7, 223, 2, 222, 8, 219, 50, 219,
	50, 219, 50, 219, 50, 0, 7, 223, 2, 223, 2, 223, 2, 223, 2, 222, 8, 219, 50, 219,
	50, 219, 50, 219, 50, 220, 2, 219, 50, 219, 50, 0, 7, 223, 2, 223, 2, 223, 2, 223,
	2, 223, 2, 223, 2, 223, 2, 223, 2, 223, 2, 219, 50, 223, 2, 223, 2, 223, 2, 32,
	2, 223, 8, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 223, 8, 32, 8, 223, 8, 219, 8, 219, 8, 32,
	8, 220, 2, 32, 2, 219, 8, 219, 8, 219, 8, 219, 8, 219, 8, 219, 8, 219, 8, 219,
	8, 220, 8, 220, 8, 220, 8, 220, 8, 220, 8, 220, 8, 219, 8, 220, 8, 220, 8, 220,
	8, 220, 8, 220, 8, 220, 8, 220, 8, 220, 8, 220, 8, 219, 8, 220, 8, 220, 8, 220,
	8, 220, 8, 220, 8, 220, 8, 219, 8, 219, 8, 219, 8, 219, 8, 220, 8, 220, 8, 220,
	8, 220, 8, 220, 8, 220, 8, 220, 8, 220, 8, 220, 8, 219, 8, 219, 8, 219, 8, 219,
	8, 219, 8, 219, 8, 219, 8, 219, 8, 32, 8, 220, 2, 32, 2, 219, 8, 219, 8, 223,
	8, 223, 8, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 219, 8, 219, 8, 32,
	8, 254, 2, 32, 2, 219, 8, 219, 8, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 219, 8, 219, 8, 32, 8, 254, 2, 32, 2, 219, 8, 219, 8, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 220, 8, 32,
	8, 220, 8, 32, 8, 220, 8, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 220, 8, 32, 8, 220, 8, 32, 8, 220, 8, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 186, 176, 25, 142, 218, 140, 6, 56, 0, 51, 237,
	232, 121, 9, 232, 160, 0, 139, 196, 5, 19, 0, 177, 4, 211, 232, 140, 210, 3, 194, 163,
	10, 0, 163, 12, 0, 3, 6, 4, 0, 163, 14, 0, 163, 24, 0, 163, 28, 0, 163, 36,
	0, 142, 6, 56, 0, 38, 161, 2, 0, 163, 32, 0, 199, 6, 42, 0, 214, 0, 140, 14,
44, 0, 191, 84, 3, 190, 57, 2, 185, 19, 0, 144, 252, 46, 172};

void 
AppendSauce(FILE * fp)
{
	char            a = 26;
	fwrite(&a, 1, 1, fp);
	sprintf(SauceDescr.id, "SAUCE");
	SauceDescr.Version[0] = '0';
	SauceDescr.Version[1] = '0';
	fwrite(&SauceDescr.id, 1, 5, fp);
	fwrite(&SauceDescr.Version, 1, 2, fp);
	fwrite(&SauceDescr.Title, 1, 35, fp);
	fwrite(&SauceDescr.Author, 1, 20, fp);
	fwrite(&SauceDescr.Group, 1, 20, fp);
	fwrite(&SauceDescr.Date, 1, 8, fp);
	fwrite(&SauceDescr.FileSize, 4, 1, fp);
	fwrite(&SauceDescr.DataType, 1, 1, fp);
	fwrite(&SauceDescr.FileType, 1, 1, fp);
	SauceDescr.TInfo1=LE_SHORT(SauceDescr.TInfo1);
	SauceDescr.TInfo2=LE_SHORT(SauceDescr.TInfo2);
	SauceDescr.TInfo3=LE_SHORT(SauceDescr.TInfo3);
	SauceDescr.TInfo4=LE_SHORT(SauceDescr.TInfo4);
	fwrite(&SauceDescr.TInfo1, 2, 1, fp);
	fwrite(&SauceDescr.TInfo2, 2, 1, fp);
	fwrite(&SauceDescr.TInfo3, 2, 1, fp);
	fwrite(&SauceDescr.TInfo4, 2, 1, fp);
	SauceDescr.TInfo1=LE_SHORT(SauceDescr.TInfo1);
	SauceDescr.TInfo2=LE_SHORT(SauceDescr.TInfo2);
	SauceDescr.TInfo3=LE_SHORT(SauceDescr.TInfo3);
	SauceDescr.TInfo4=LE_SHORT(SauceDescr.TInfo4);
	fwrite(&SauceDescr.Comments, 1, 1, fp);
	fwrite(&SauceDescr.Flags, 1, 1, fp);
	fwrite(&SauceDescr.Filler, 1, 22, fp);
}

void 
ReadSauce(FILE * fp)
{
	SauceRecord     Tmp;
	fseek(fp, -128, SEEK_END);
	fread(&Tmp.id, 1, 5, fp);
	fread(&Tmp.Version, 1, 2, fp);
	fread(&Tmp.Title, 1, 35, fp);
	fread(&Tmp.Author, 1, 20, fp);
	fread(&Tmp.Group, 1, 20, fp);
	fread(&Tmp.Date, 1, 8, fp);
	Tmp.Title[35] = 0;
	Tmp.Group[20] = 0;
	Tmp.Author[20] = 0;
	fread(&Tmp.FileSize, 4, 1, fp);
	Tmp.FileSize=LE_LONG(Tmp.FileSize);
	fread(&Tmp.DataType, 1, 1, fp);
	fread(&Tmp.FileType, 1, 1, fp);
	fread(&Tmp.TInfo1, 2, 1, fp);
	Tmp.TInfo1=LE_SHORT(Tmp.TInfo1);
	fread(&Tmp.TInfo2, 2, 1, fp);
	Tmp.TInfo2=LE_SHORT(Tmp.TInfo2);
	fread(&Tmp.TInfo3, 2, 1, fp);
	Tmp.TInfo3=LE_SHORT(Tmp.TInfo3);
	fread(&Tmp.TInfo4, 2, 1, fp);
	Tmp.TInfo4=LE_SHORT(Tmp.TInfo4);
	fread(&Tmp.Comments, 1, 1, fp);
	fread(&Tmp.Flags, 1, 1, fp);
	fread(&Tmp.Filler, 1, 22, fp);
	if ((Tmp.id[0] == 'S') & (Tmp.id[1] == 'A') &
	    (Tmp.id[2] == 'U') & (Tmp.id[3] == 'C') & (Tmp.id[4] == 'E')) {
		SauceDescr = Tmp;
		SaveSauce = TRUE;
	} else {
		memset(&SauceDescr, 0, sizeof(SauceDescr));
		SaveSauce = FALSE;
	}
}



void 
SauceSet(void)
{
	char           *nul;
	int             ch, a = 0, b, l;
	struct			text_info	ti;
	struct			mouse_event	me;
	char			buf[35*2];

	gettextinfo(&ti);
	puttext(1,1,80,ti.screenheight>24?25:ti.screenheight,(char *)SauceAnsi);
	do {
		bufprintf(buf,15,"%s",SauceDescr.Title);
		for (b = strlen(SauceDescr.Title); b < 35; b++) {
			buf[b*2]='\xfa';
			buf[b*2+1]=7;
		}
		puttext(29,11,63,11,buf);

		bufprintf(buf,15,"%s", SauceDescr.Author);
		for (b = strlen(SauceDescr.Author); b < 20; b++) {
			buf[b*2]='\xfa';
			buf[b*2+1]=7;
		}
		puttext(29,12,48,12,buf);

		bufprintf(buf,15,"%s", SauceDescr.Group);
		for (b = strlen(SauceDescr.Group); b < 20; b++) {
			buf[b*2]='\xfa';
			buf[b*2+1]=7;
		}
		puttext(29, 13, 48, 13, buf);

		buf[0]='x';
		buf[1]=15;
		buf[2]=' ';
		buf[3]=15;
		if (SaveSauce)
			puttext(41,9,41,9,buf);
		else
			puttext(41,9,41,9,buf+2);
		if (!SaveSauce)
			puttext(50,9,50,9,buf);
		else
			puttext(50,9,50,9,buf+2);
		buf[0]='>';
		buf[1]=14;
		buf[2]=' ';
		buf[3]=14;
		for(b=0; b<=3; b++)
			puttext(15,9+b+(b==0?0:1),15,9+b+(b==0?0:1),buf+(a==b?0:2));
		ch = newgetch();
		if(ch==CIO_KEY_MOUSE) {
			/* ToDo Mouse Stuff */
			getmouse(&me);
			if(me.event==CIOLIB_BUTTON_1_CLICK) {
				if(me.endx>=40 && me.endx <=47 && me.endy == 9)
					SaveSauce=TRUE;
				if(me.endx>=49 && me.endx <=56 && me.endy == 9)
					SaveSauce=FALSE;
				if(me.endy==11 && me.endx >= 29 && me.endx <= 63) {
					a=1;
					ch=13;
				}
				if(me.endy==12 && me.endx >= 29 && me.endx <= 48) {
					a=2;
					ch=13;
				}
				if(me.endy==13 && me.endx >= 29 && me.endx <= 48) {
					a=3;
					ch=13;
				}
				for(b=0; b<=3; b++)
					puttext(15,9+b+(b==0?0:1),15,9+b+(b==0?0:1),buf+(a==b?0:2));
			}
			if(me.event==CIOLIB_BUTTON_3_CLICK)
				ch=27;
		}
		switch (ch) {
		case 13:
			switch (a) {
			case 0:
				SaveSauce = !SaveSauce;
				break;
			case 1:
				nul = inputfield((char *)SauceDescr.Title, 35, 28, 10);
				l=strlen(nul);
				for (b = 0; b <= l; b++)
					SauceDescr.Title[b] = nul[b];
				break;
			case 2:
				nul = inputfield((char *)SauceDescr.Author, 20, 28, 11);
				l=strlen(nul);
				for (b = 0; b <= l; b++)
					SauceDescr.Author[b] = nul[b];
				break;
			case 3:
				nul = inputfield((char *)SauceDescr.Group, 20, 28, 12);
				l=strlen(nul);
				for (b = 0; b <= l; b++)
					SauceDescr.Group[b] = nul[b];
				break;
			}
			break;
		case CIO_KEY_UP:
			if (a > 0)
				a--;
			else
				a = 3;
			break;
		case CIO_KEY_DOWN:
			if (a < 3)
				a++;
			else
				a = 0;
			break;
		}
	} while (ch != 27);
}
